package com.elitesland.tw.tw5.server.common.scheduling;

import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/30 - 21:59
 */
public class TimeUtil {
    //string 转 cron格式
    public static String formatDateByPattern(Date date, String dateFormat){
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }
    public static String getCron(Date  date){
        String dateFormat="ss mm HH dd MM ?";
        //String dateFormat="ss mm HH dd MM ? yyyy";
        return formatDateByPattern(date, dateFormat);
    }

    public static String dateToYmd(LocalDate date) {
        return date == null ? "" : date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate dateFromYmd(String ymd) {
        return StringUtils.isEmpty(ymd) ? null : LocalDate.parse(ymd, DateTimeFormatter.ISO_LOCAL_DATE);
    }

}
