package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_user_role", indexes = {
        @Index(name = "role_index", columnList = "role_id"),
        @Index(name = "user_index", columnList = "user_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_system_user_role", comment = "系统用户角色表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemUserRoleDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;
    @Comment("菜单id")
    @Column(name = "user_id")
    private Long userId;

    @Comment("角色id")
    @Column(name = "role_id")
    private Long roleId;


}
