/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class BeanMapTool {
    public static Map<String, Object> beanToMap(Object obj) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Object o = new Object();
            try {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                Method getMethod = pd.getReadMethod();
                o = getMethod.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.put(field.getName(), o);
        }
        return map;
    }

    public static <T> T mapToBean(Class<T> clazz, Map<String, Object> map) {
        T bean = null;
        try {
            bean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
                String key = stringObjectEntry.getKey();
                Object value = stringObjectEntry.getValue();
                Field field = BeanMapTool.getClassField(clazz, key);
                if (field == null) continue;
                String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
                Method method = clazz.getMethod(methodName, field.getType());
                method.invoke(bean, value);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return bean;
    }

    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
            if (!declaredField.getName().equals(fieldName)) continue;
            return declaredField;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (null != superclass) {
            return BeanMapTool.getClassField(superclass, fieldName);
        }
        return null;
    }
}

