/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.controller;

import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdScheduleQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u65e5\u7a0b\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/scd"})
public class PrdScheduleController {
    private static final Logger log = LoggerFactory.getLogger(PrdScheduleController.class);
    private final PrdScheduleService service;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/schedule/saveOne"})
    public TwOutputUtil insert(@RequestBody PrdSchedulePayload payload) {
        PrdScheduleVO vo = this.service.insertOrUpdate(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/schedule/list"})
    @UdcNameClass
    public TwOutputUtil queryList(PrdScheduleQuery query) {
        List list = this.service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/schedule/detail/{id}"})
    @UdcNameClass
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        PrdScheduleVO vo = this.service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }

    @DeleteMapping(value={"/schedule/delete"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/schedule/deleteCurrent"})
    public TwOutputUtil deleteCurrent(@RequestParam Long scheduleId, @RequestParam String date) {
        this.service.deleteCurrent(scheduleId, date);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/schedule/deleteAfter"})
    public TwOutputUtil deleteAfter(@RequestParam Long scheduleId, @RequestParam String date) {
        this.service.deleteAfter(scheduleId, date);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/schedule/updateCurrent"})
    public TwOutputUtil updateCurrent(@RequestBody PrdSchedulePayload payload) {
        this.service.updateCurrent(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/schedule/updateAfter"})
    public TwOutputUtil updateAfter(@RequestBody PrdSchedulePayload payload) {
        this.service.updateAfter(payload);
        return TwOutputUtil.ok();
    }

    public PrdScheduleController(PrdScheduleService service) {
        this.service = service;
    }
}

