/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemRoleController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemRoleController.class);
    private final PrdSystemRoleService service;

    @PostMapping(value={"/role/insert"})
    public TwOutputUtil insert(@RequestBody PrdSystemRolePayload entity) {
        PrdSystemRoleVO vo = this.service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/role/updateStatus"})
    public TwOutputUtil updateStatus(Long id, Boolean enabled) {
        this.service.updateStatus(id, enabled);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/role/update"})
    public TwOutputUtil update(@RequestBody PrdSystemRolePayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/role/deleteSoft"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/role/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemRoleVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/role/list"})
    public TwOutputUtil queryList() {
        List paging = this.service.queryList();
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/role/paging"})
    public TwOutputUtil usableList(PrdSystemRoleQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    public PrdSystemRoleController(PrdSystemRoleService service) {
        this.service = service;
    }
}

