/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemLogConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemLogDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemLogDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemLogRepo;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PrdSystemLogServiceImpl
implements PrdSystemLogService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemLogServiceImpl.class);
    private final PrdSystemLogRepo repo;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogDAO dao;
    private final EntityManager entityManager;

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveNewLog(Long objectId, String logObjectType, String objectName) {
        PrdSystemLogDO logDO = new PrdSystemLogDO();
        logDO.setObjectId(objectId);
        logDO.setLogObject(logObjectType);
        logDO.setLogContent(objectName);
        this.dao.save(logDO);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveNewLog(Long objectId, String logObjectType, String objectName, String extString1) {
        PrdSystemLogDO logDO = new PrdSystemLogDO();
        logDO.setObjectId(objectId);
        logDO.setLogObject(logObjectType);
        logDO.setLogContent(objectName);
        logDO.setExtString1(extString1);
        this.dao.save(logDO);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveNewLog(Long objectId, String logObjectType, String objectName, Long createUserId) {
        PrdSystemLogDO logDO = new PrdSystemLogDO();
        logDO.setObjectId(objectId);
        logDO.setLogObject(logObjectType);
        logDO.setLogContent(objectName);
        if (null != createUserId) {
            logDO.setCreateUserId(createUserId);
        }
        this.dao.save(logDO);
    }

    public List<PrdSystemLogVO> queryLogList(Long objectId, String logObjectType) {
        List<PrdSystemLogDO> logDOS = this.dao.queryByObjectIdAndObjectType(objectId, logObjectType);
        List<PrdSystemLogVO> collect = logDOS.stream().map(e -> {
            PrdSystemLogVO vo = PrdSystemLogConvert.INSTANCE.toVo((PrdSystemLogDO)((Object)e));
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }

    public PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery logQuery) {
        Specification<PrdSystemLogDO> spec = this.dao.getSpec(logQuery);
        Page<PrdSystemLogDO> all = this.dao.findAll(spec, (Pageable)logQuery.getPageRequest());
        List content = all.getContent();
        List collect = content.stream().map(e -> {
            PrdSystemLogVO vo = PrdSystemLogConvert.INSTANCE.toVo((PrdSystemLogDO)((Object)e));
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            return vo;
        }).collect(Collectors.toList());
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    public PrdSystemLogServiceImpl(PrdSystemLogRepo repo, CacheUtil cacheUtil, PrdSystemLogDAO dao, EntityManager entityManager) {
        this.repo = repo;
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.entityManager = entityManager;
    }
}

