/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.file.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileQuery;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/file"})
public class PrdFileController {
    private static final Logger log = LoggerFactory.getLogger(PrdFileController.class);
    private final PrdFileService prdFileService;

    @PostMapping(value={"/file/upload"})
    public TwOutputUtil upload(@RequestParam(required=false) String name, @RequestParam(required=false) Long folderId, @RequestParam(value="file") MultipartFile file) {
        PrdFileVO upload = this.prdFileService.upload(name, folderId, file);
        return TwOutputUtil.ok(upload);
    }

    @PostMapping(value={"/file/pictures"})
    public TwOutputUtil uploadPicture(@RequestParam(value="folderId") Long folderId, @RequestParam MultipartFile file) {
        String suffix = FileUtil.getExtensionName(file.getOriginalFilename());
        if (!"\u56fe\u7247".equals(FileUtil.getFileType(suffix))) {
            throw TwException.error("0801", "\u53ea\u80fd\u4e0a\u4f20\u56fe\u7247");
        }
        PrdFileVO prdFileVO = this.prdFileService.upload(null, folderId, file);
        return TwOutputUtil.ok(prdFileVO);
    }

    @GetMapping(value={"/file/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdFileVO prdFileVO = this.prdFileService.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    @GetMapping(value={"/file/paging"})
    public TwOutputUtil paging(PrdFileQuery query) {
        PagingVO paging = this.prdFileService.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/file/list"})
    public TwOutputUtil queryList(PrdFileQuery query) {
        List vos = this.prdFileService.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    @DeleteMapping(value={"/file/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.prdFileService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/file/preview/{key}"})
    public ResponseEntity preview(@PathVariable Long key) {
        PrdFileVO prdFileVO = this.prdFileService.queryByKey(key);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{prdFileVO.getFileType()})).header("Content-Length", new String[]{String.valueOf(prdFileVO.getFileSize())})).header("Content-Disposition", new String[]{"filename*=" + StandardCharsets.UTF_8 + "''" + prdFileVO.getName()})).body((Object)new PathResource(prdFileVO.getServerPath()));
        return responseEntity;
    }

    @GetMapping(value={"/file/download/{key}"})
    @ApiOperation(value="\u9644\u4ef6\u4e0b\u8f7d")
    public ResponseEntity<Resource> download(@PathVariable Long key) throws IOException {
        PrdFileVO prdFileVO = this.prdFileService.queryByKey(key);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{prdFileVO.getFileType()})).header("Content-Length", new String[]{String.valueOf(prdFileVO.getFileSize())})).header("Content-Disposition", new String[]{"attachment; filename=" + URLEncoder.encode(prdFileVO.getName(), StandardCharsets.UTF_8.name())})).body((Object)new PathResource(prdFileVO.getServerPath()));
        return responseEntity;
    }

    public PrdFileController(PrdFileService prdFileService) {
        this.prdFileService = prdFileService;
    }
}

