/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemMenuPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemMenuService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u83dc\u5355\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemMenuController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemMenuController.class);
    private final PrdSystemMenuService service;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/menu/insert"})
    public TwOutputUtil insert(PrdSystemMenuPayload entity) {
        PrdSystemMenuVO vo = this.service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u72b6\u6001\u4fee\u6539")
    @PutMapping(value={"/menu/updateStatus"})
    public TwOutputUtil updateStatus(Long id, Integer menuStatus) {
        this.service.updateStatus(id, menuStatus);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/menu/update"})
    public TwOutputUtil update(PrdSystemMenuPayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/menu/delete/{key}"})
    public TwOutputUtil delete(@PathVariable Long key) {
        this.service.delete(key);
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/menu/deleteSoft/{key}"})
    public TwOutputUtil deleteSoft(@PathVariable Long key) {
        this.service.deleteSoft(key);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @GetMapping(value={"/menu/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemMenuVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/menu/list"})
    public TwOutputUtil queryList() {
        List paging = this.service.queryList();
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/menu/usableList"})
    public TwOutputUtil usableList() {
        List paging = this.service.usableList();
        return TwOutputUtil.ok(paging);
    }

    public PrdSystemMenuController(PrdSystemMenuService service) {
        this.service = service;
    }
}

