package com.elitesland.tw.tw5.server.prd.prj.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Author carl.wang
 * @Description
 * @Date
 **/
@Entity
@Table(name = "prj_project_member", indexes = {@Index(name = "user_index", columnList = "user_id"), @Index(name = "project_index", columnList = "project_id")})
@org.hibernate.annotations.Table(appliesTo = "prj_project_member", comment = "项目成员表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrjProjectMemberDO extends BaseModel {

    @Comment("项目id")
    @Column(name = "project_id")
    private Long projectId;

    @Comment("项目编号")
    @Column(name = "user_id")
    private Long userId;

    @Comment("用户名")
    @Column()
    private String employeeName;

}
