package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemTagPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemTagQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemTagService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 系统标签项管理
 *
 * @author wangding
 */
@Api("系统标签项")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemTagController {

    private final PrdSystemTagService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/tag")
    public TwOutputUtil insert(PrdSystemTagPayload entity) {
        PrdSystemTagVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/tag")
    public TwOutputUtil update(PrdSystemTagPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/tag/paging")
    public TwOutputUtil findByConditionPaging(PrdSystemTagQuery query) {
        PagingVO<PrdSystemTagVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 列表查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/tag/list")
    public TwOutputUtil queryList(PrdSystemTagQuery query) {
        List<PrdSystemTagVO> paging = service.queryList(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/tag")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/tag/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemTagVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 清空消息提醒缓存
     *
     * @return result
     */
    @ApiOperation("清空消息提醒缓存")
    @GetMapping("/tag/clearCache")
    public TwOutputUtil clearCache() {
        service.clearCache();
        return TwOutputUtil.ok();
    }

}
