package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_function_data", indexes = {@Index(name = "function_index", columnList = "function_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_system_function_data", comment = "系统功能数据权限表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemFunctionDataDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Comment("功能ID")
    @Column(name = "function_id")
    private Long functionId;

    @Comment("权限类型")
    @Column()
    private Integer functionPermissionType;//1：模块级权限，2：数据行级权限

    @Comment("行权限控制的属性名称")
    @Column()
    private String functionFieldName;

    @Comment("名称")
    @Column()
    private String functionDataName;

    @Comment("允许操作角色或职位")
    @Column()
    private String functionDataRoles;


    @Comment("操作行为类型")
    @Column()
    private Integer functionDataType;//1001：查看，1002:修改，1003：删除，1004：共享


}
