package com.elitesland.tw.tw5.server.prd.work.dao;

import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentHistoryQuery;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentHistoryVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.work.entity.QPrdWorkAssignmentHistoryDO;
import com.elitesland.tw.tw5.server.prd.work.repo.PrdWorkAssignmentHistoryRepo;
import com.elitesland.tw.tw5.server.prd.work.entity.PrdWorkAssignmentHistoryDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdWorkAssignmentHistoryDAO {
    private final PrdWorkAssignmentHistoryRepo repo;

    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdWorkAssignmentHistoryDO qdo = QPrdWorkAssignmentHistoryDO.prdWorkAssignmentHistoryDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdWorkAssignmentHistoryDO save(PrdWorkAssignmentHistoryDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存数组
     *
     * @param adoList do对象数组
     * @return 保存后的对象
     */
    public List<PrdWorkAssignmentHistoryDO> saveAll(List<PrdWorkAssignmentHistoryDO> adoList) {
        return repo.saveAll(adoList);
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdWorkAssignmentHistoryVO> queryListDynamic(PrdWorkAssignmentHistoryQuery query) {
        JPAQuery<PrdWorkAssignmentHistoryVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdWorkAssignmentHistoryVO> getJpaQueryWhere(PrdWorkAssignmentHistoryQuery query) {
        JPAQuery<PrdWorkAssignmentHistoryVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getAssignmentId())) {
            jpaQuery.where(qdo.assignmentId.in(query.getAssignmentId()));
        }
        if (StringUtils.hasText(query.getOperationAction())) {
            jpaQuery.where(qdo.operationAction.eq(query.getOperationAction()));
        }
        jpaQuery.where(qdo.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdWorkAssignmentHistoryVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdWorkAssignmentHistoryVO.class,
                qdo.assignmentId,
                qdo.operationAction,
                qdo.operationTitle,
                qdo.id,
                qdo.createTime,
                qdo.createUserId,
                qdo.creator,
                qdo.remark
        )).from(qdo);
    }
}
