package com.elitesland.tw.tw5.server.common.service;

import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Field;
import java.util.*;

/**
 * 数据翻译
 */
@Service
@RequiredArgsConstructor
public class TransferUtilServiceImpl {
    private final CacheUtil cacheUtil;
    private final TransferUtilDAO dao;

    /**
     * Bean对象转换Map方式一（基于JDK实现）
     *
     * @param obj
     * @return
     */
    public Map<String, Object> beanToMap(Object obj) {
        Map<String, Object> map = BeanUtil.beanToMap(obj);//解决不能翻译继承父类字段的问题，先调用基础方法
//        Map<String, Object> map = new HashMap<String, Object>();
        List<Long> userIds = new ArrayList<>();
        List<Long> orgIds = new ArrayList<>();
        List<Long> bookIds = new ArrayList<>();
        List<Long> oppoIds = new ArrayList<>();
        for (Field field : obj.getClass().getDeclaredFields()) {
            Object o = null;
            try {

                field.setAccessible(true);
                o = field.get(obj);
                if (o != null && field.get(obj) instanceof Long) {
                    if (field.getName().contains("userId") || field.getName().contains("UserId")) {
                        userIds.add((Long) field.get(obj));
                    }
                    if (field.getName().contains("orgId") || field.getName().contains("OrgId")) {
                        orgIds.add((Long) field.get(obj));
                    }
                    if (field.getName().contains("bookId") || field.getName().contains("BookId")) {
                        bookIds.add((Long) field.get(obj));
                    }
                    if (field.getName().contains("oppoId") || field.getName().contains("OppoId")) {
                        oppoIds.add((Long) field.get(obj));
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            map.put(field.getName(), o);
        }
        List<Map<String, Long>> tw4UserMaps = new ArrayList<>();

        if (userIds.size() > 0) {
            tw4UserMaps = dao.queryEmployeeTw4Maps(userIds);
        }
        List<Map<String, Long>> tw4OrgMaps = new ArrayList<>();
        if (orgIds.size() > 0) {
            tw4OrgMaps = dao.queryOrgTw4Maps(orgIds);
        }
        List<Map<String, Long>> tw4BookMaps = new ArrayList<>();
        if (bookIds.size() > 0) {
            tw4BookMaps = dao.queryBookTw4Maps(bookIds);
        }
        List<Map<String, Long>> tw4OppoMaps = new ArrayList<>();
        if (oppoIds.size() > 0) {
            tw4OppoMaps = dao.queryOppoTw4Maps(oppoIds);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() != null && entry.getValue() instanceof Long) {
                if ((entry.getKey().contains("userId") || entry.getKey().contains("UserId")) && !entry.getKey().contains("V4")) {
                    Optional<Map<String, Long>> userId = tw4UserMaps.stream().filter(tw4UserMap -> Long.valueOf(tw4UserMap.get("userId") + "").longValue() == ((Long) entry.getValue()).longValue()).findFirst();
                    if(userId.isPresent()){
                        map.put(entry.getKey(), userId.get().get("userIdV4"));
                    }

                }
                if ((entry.getKey().contains("orgId") || entry.getKey().contains("OrgId")) && !entry.getKey().contains("V4")) {
                    Map<String, Long> orgMap = tw4OrgMaps.stream().filter(tw4OrgMap -> Long.valueOf(tw4OrgMap.get("id") + "").longValue() == ((Long) entry.getValue()).longValue()).findFirst().get();
                    map.put(entry.getKey(), orgMap.get("orgIdV4"));
                }
                if ((entry.getKey().contains("bookId") || entry.getKey().contains("BookId")) && !entry.getKey().contains("V4")) {
                    //2023-07-04 线索转商机的时候报错了 tw4BookMaps中没有值 因此加个判断
                    if(!CollectionUtils.isEmpty(tw4BookMaps)){
                        Map<String, Long> bookMap = tw4BookMaps.stream().filter(tw4BookMap -> Long.valueOf(tw4BookMap.get("id")).longValue() == ((Long) entry.getValue()).longValue()).findFirst().get();
                        map.put(entry.getKey(), bookMap.get("bookIdV4"));
                    }
                }
                if ((entry.getKey().contains("oppoId") || entry.getKey().contains("OppoId")) && !entry.getKey().contains("V4")) {
                    Map<String, Long> oppoMap = tw4OppoMaps.stream().filter(tw4OppoMap -> Long.valueOf(tw4OppoMap.get("id") + "").longValue() == ((Long) entry.getValue()).longValue()).findFirst().get();
                    map.put(entry.getKey(), oppoMap.get("oppoIdV4"));
                }
            }
        }

        return map;
    }

    /**
     * 查询tw4.0 用户ids
     *
     * @param userIds
     * @return
     */
    public List<Long> queryEmployeeTw4Ids(List<Long> userIds) {
        return dao.queryEmployeeTw4Ids(userIds);
    }

}
