package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 附件业务关系表
 *
 * @author duwh
 * @date 2022/11/23
 */
@Entity
@Table(name = "prd_fsm_file_ref")
@org.hibernate.annotations.Table(appliesTo = "prd_fsm_file_ref", comment = "通用附件业务关系表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdFsmFileRefDO extends BaseModel {

    @Comment("业务类型：枚举：经营计划：OPER_PLAN  ....")
    @Column()
    private String objType;

    @Comment("业务主键")
    @Column()
    private Long objId;

    @Comment("附件编码")
    @Column()
    private String fileCode;

    @Comment("自定义附件名称")
    @Column()
    private String fileName;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;


    public PrdFsmFileRefDO() {
    }

    public void copy(PrdFsmFileRefDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
