package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 问题反馈处理过程表
 * @author Lemon
 */
@Entity
@Table(name = "prd_system_problem_feedback_process")
@org.hibernate.annotations.Table(appliesTo = "prd_system_problem_feedback_process", comment = "问题反馈处理过程表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemProblemFeedbackProcessDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 7494073443941889725L;

    @Comment("问题反馈id")
    @Column()
    private Long feedbackId;

    @Comment("处理内容")
    @Column()
    private String content;

    @Comment("处理类型")
    @Column()
    private String processType;

    @Comment("附件")
    @Column()
    private String fileCodes;
}
