package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemMenuPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemMenuQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemMenuService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemMenuConvert;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemMenuDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemMenuDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemMenuServiceImpl implements PrdSystemMenuService {
    private final PrdSystemMenuDAO dao;

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Transactional
    @Override
    public PrdSystemMenuVO insert(PrdSystemMenuPayload payload) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        query.setMenuCode(payload.getMenuCode());
        int count = dao.queryList(query).size();
        if (count > 0) {
            throw TwException.error("", "编号不可重复");
        }

        PrdSystemMenuDO ado = PrdSystemMenuConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        return PrdSystemMenuConvert.INSTANCE.toVo(ado);
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Transactional
    @Override
    public Long update(PrdSystemMenuPayload payload) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        query.setMenuCode(payload.getMenuCode());
        List<PrdSystemMenuVO> list = dao.queryList(query);
        if (list.size() == 0 || (list.size() == 1 && list.get(0).getId().longValue() == payload.getId().longValue())) {
            if (payload.getMenuStatus() == 1) {
                List<Long> menuIds = new ArrayList<>();
                getUpdateMenu(payload.getId(), menuIds, list);
                dao.updateStatus(menuIds, 1);
            }
            dao.updateByKeyDynamic(payload);
            return 0L;
        }
        throw TwException.error("", "编号不可重复");
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Transactional
    @Override
    public Long updateStatus(Long id, Integer status) {
        if (!ObjectUtils.isEmpty(id) && !ObjectUtils.isEmpty(status)) {
            List<Long> menuIds = new ArrayList<>();
            menuIds.add(id);
            if (status == 1) {
                //如果是禁用，则包含禁用子项
                List<PrdSystemMenuVO> menuVOS = dao.usableList();
                getUpdateMenu(id, menuIds, menuVOS);
            }
            dao.updateStatus(menuIds, status);
            return 0L;
        } else {
            throw TwException.error("", "参数错误");
        }

    }

    void getUpdateMenu(Long munuId, List<Long> menuIds, List<PrdSystemMenuVO> menuVOS) {
        for (PrdSystemMenuVO menuVO : menuVOS) {
            if (menuVO.getMenuStatus() == 0 && menuVO.getParentId() != null && menuVO.getParentId().longValue() == munuId.longValue()) {
                menuIds.add(menuVO.getId());
                getUpdateMenu(menuVO.getId(), menuIds, menuVOS);
            }
        }
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Transactional
    @Override
    public boolean delete(Long key) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        query.setParentId(key);
        List<PrdSystemMenuVO> pvos = dao.queryList(query);
        if (pvos != null && pvos.size() > 0) {
            throw TwException.error("", "存在子项数据");
        }
        dao.delete(key);
        return true;
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Transactional
    @Override
    public boolean deleteSoft(Long key) {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        List<PrdSystemMenuVO> pvos = dao.queryList(query);
        List<Long> menuIds = new ArrayList<>();
        menuIds.add(key);
        getUpdateMenu(key, menuIds, pvos);
        dao.deleteSoft(menuIds);
        return true;
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Override
    public PrdSystemMenuVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Override
    public List<PrdSystemMenuVO> queryList() {
        PrdSystemMenuQuery query = new PrdSystemMenuQuery();
        List<PrdSystemMenuVO> pvos = dao.queryList(query);
        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
        if (loginGeneralUser.isTenantAdmin()) {
            return pvos.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        // TreeListUtil.toTree(pvos);
        return pvos;
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Override
    public List<PrdSystemMenuVO> usableList() {
        List<PrdSystemMenuVO> prdSystemMenuVOS = dao.usableList();
        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
        if (loginGeneralUser.isSystemAdmin() || loginGeneralUser.isTenantAdmin()) {
            return prdSystemMenuVOS.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        return prdSystemMenuVOS;
    }

    @Override
    public List<PrdSystemMenuVO> selectByCondition(String key) {
        return null;
    }
}
