/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.app.service;

import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.app.payload.AppVersionPayload;
import com.elitesland.tw.tw5.api.prd.app.query.AppVersionQuery;
import com.elitesland.tw.tw5.api.prd.app.service.AppVersionService;
import com.elitesland.tw.tw5.api.prd.app.vo.AppVersionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.app.convert.AppVersionConvert;
import com.elitesland.tw.tw5.server.prd.app.entity.AppVersionDO;
import com.elitesland.tw.tw5.server.prd.app.repo.AppVersionRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AppVersionServiceImpl
implements AppVersionService {
    private static final Logger log = LoggerFactory.getLogger(AppVersionServiceImpl.class);
    private final AppVersionRepo appVersionRepo;
    private final FileService fileService;

    public PagingVO<AppVersionVO> paging(AppVersionQuery query) {
        Page page = this.appVersionRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(AppVersionConvert.INSTANCE::toVo));
    }

    public List<AppVersionVO> queryList(AppVersionQuery query) {
        return AppVersionConvert.INSTANCE.toVoList(this.appVersionRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public AppVersionVO queryByKey(Long key) {
        AppVersionDO entity = this.appVersionRepo.findById(key).orElseGet(AppVersionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AppVersionVO vo = AppVersionConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AppVersionVO insert(AppVersionPayload payload) {
        this.dataProcess(payload);
        AppVersionDO entityDo = AppVersionConvert.INSTANCE.toDo(payload);
        return AppVersionConvert.INSTANCE.toVo((AppVersionDO)this.appVersionRepo.save(entityDo));
    }

    private void dataProcess(AppVersionPayload payload) {
        String fileCode;
        if (null == payload.getShowFlag()) {
            payload.setShowFlag(Integer.valueOf(0));
        }
        if (StringUtils.hasText((String)(fileCode = payload.getFileCode()))) {
            payload.setDownloadUrl("/com/file/v1/" + fileCode + "/download");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public AppVersionVO update(AppVersionPayload payload) {
        AppVersionDO entity = this.appVersionRepo.findById(payload.getId()).orElseGet(AppVersionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.dataProcess(payload);
        AppVersionDO entityDo = AppVersionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AppVersionConvert.INSTANCE.toVo((AppVersionDO)this.appVersionRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.appVersionRepo.findById(id);
                if (!optional.isEmpty()) {
                    AppVersionDO entity = (AppVersionDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.appVersionRepo.save(entity);
                }
            });
        }
    }

    public AppVersionVO getCurrentVersion() {
        List records;
        AppVersionQuery query = new AppVersionQuery();
        query.setShowFlag(Integer.valueOf(1));
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        OrderItem orderItem = OrderItem.desc((String)"version");
        OrderItem orderItem2 = OrderItem.desc((String)"createTime");
        orderItemList.add(orderItem);
        orderItemList.add(orderItem2);
        query.setOrders(orderItemList);
        query.setSize(Integer.valueOf(1));
        PagingVO<AppVersionVO> paging = this.paging(query);
        if (paging != null && !CollectionUtils.isEmpty((Collection)(records = paging.getRecords()))) {
            return (AppVersionVO)records.get(0);
        }
        return null;
    }

    public AppVersionServiceImpl(AppVersionRepo appVersionRepo, FileService fileService) {
        this.appVersionRepo = appVersionRepo;
        this.fileService = fileService;
    }
}

