/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.api.prd.app.vo.PrdUserDataForAppVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserCompositeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QPrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.my.repo.PrdUserRemindRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeCompositeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdRemindConfigDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemShortcutDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemUserRoleDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PrdUserDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserRemindRepo userRemindRepo;
    private final QPrdOrgEmployeeDO qdo = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgRoleDO qdoRole = QPrdOrgRoleDO.prdOrgRoleDO;
    private final QPrdSystemShortcutDO qdoShortcut = QPrdSystemShortcutDO.prdSystemShortcutDO;
    private final QPrdSystemMenuDO qdoMenu = QPrdSystemMenuDO.prdSystemMenuDO;
    private final QPrdSystemRoleMenuDO qdoRoleMenu = QPrdSystemRoleMenuDO.prdSystemRoleMenuDO;
    private final QPrdSystemRoleDO qdoSysRole = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    private final QPrdRemindConfigDO qdoRemind = QPrdRemindConfigDO.prdRemindConfigDO;
    private final QPrdUserRemindDO qdoUserRemind = QPrdUserRemindDO.prdUserRemindDO;
    private final QPrdOrgEmployeeCompositeDO qdoComposite = QPrdOrgEmployeeCompositeDO.prdOrgEmployeeCompositeDO;

    public PrdUserRemindDO saveUserRemind(PrdUserRemindDO ado) {
        return (PrdUserRemindDO)this.userRemindRepo.save(ado);
    }

    public PrdUserRemindDO queryUserRemind(Long userId, String type) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoUserRemind).from((EntityPath)this.qdoUserRemind);
        jpaQuery.where((Predicate)this.qdoUserRemind.userId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoUserRemind.remindType.eq((Object)type));
        return (PrdUserRemindDO)jpaQuery.fetchFirst();
    }

    public List<PrdUserRemindVO> queryReminds(Long userId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdUserRemindVO.class, (Expression[])new Expression[]{this.qdoRemind.id, this.qdoRemind.remindType, this.qdoRemind.remindContent, this.qdoRemind.remindTitle, this.qdoRemind.priority, this.qdoUserRemind.noRemindDate, this.qdoUserRemind.createTime})).from((EntityPath)this.qdoRemind)).leftJoin((EntityPath)this.qdoUserRemind)).on((Predicate)this.qdoRemind.remindType.eq((Expression)this.qdoUserRemind.remindType).and((Predicate)this.qdoUserRemind.userId.eq((Object)userId)));
        jpaQuery.where((Predicate)this.qdoRemind.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQueryDataSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgEmployeeRefVO.class, (Expression[])new Expression[]{this.qdoRef.id, this.qdoRef.userId, this.qdoRef.orgId, this.qdoRef.parentId, this.qdo.employeeName, this.qdoRef.joinDate, this.qdoRef.leaveDate, this.qdoRef.isDefault, this.qdoRef.remark, this.qdoRef.createUserId, this.qdoRef.createTime})).from((EntityPath)this.qdoRef)).leftJoin((EntityPath)this.qdo)).on((Predicate)this.qdo.userId.longValue().eq((Expression)this.qdoRef.userId.longValue()));
    }

    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId, Long userId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = this.getJpaQueryDataSelect();
        jpaQuery.where((Predicate)this.qdoRef.parentId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRef.isCopy.eq((Object)0));
        if (orgId != null) {
            jpaQuery.where((Predicate)this.qdoRef.orgId.eq((Object)orgId));
        }
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdOrgDataRefVO> getJpaQueryOrgSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgDataRefVO.class, (Expression[])new Expression[]{this.qdoRef.id, this.qdoRef.userId, this.qdoRef.orgId, this.qdoRef.parentId, this.qdoRef.joinDate, this.qdoRef.leaveDate, this.qdoRef.isDefault, this.qdoOrg.orgName, this.qdoRef.remark, this.qdoRef.createUserId, this.qdoRef.createTime})).from((EntityPath)this.qdoRef)).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()));
    }

    public List<PrdOrgDataRefVO> queryOrgListByKey(Long userId) {
        JPAQuery<PrdOrgDataRefVO> jpaQuery = this.getJpaQueryOrgSelect();
        jpaQuery.where((Predicate)this.qdoRef.userId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoRef.isCopy.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdUserDataVO> getJpaQueryEmployeeSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdUserDataVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.userId, this.qdo.shortcutIds, this.qdo.employeeName, this.qdo.jobs, this.qdo.companyId, this.qdo.eqvaRatio, this.qdoCompany.companyName, this.qdoPerson.headCodes, this.qdoRef.orgId, this.qdoOrg.orgName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.userId.longValue().eq((Expression)this.qdoRef.userId.longValue()).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)).and((Predicate)this.qdoRef.isCopy.eq((Object)0)).and((Predicate)this.qdoRef.isDefault.eq((Object)0)))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()).and((Predicate)this.qdoOrg.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoCompany.id.longValue().eq((Expression)this.qdo.companyId.longValue()).and((Predicate)this.qdoCompany.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoPerson)).on((Predicate)this.qdoPerson.id.longValue().eq((Expression)this.qdo.personId.longValue()));
    }

    private JPAQuery<PrdUserDataForAppVO> getJpaQueryEmployeeSelectForApp() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdUserDataForAppVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.employeeName, this.qdo.jobs, this.qdoPerson.sex, this.qdoPerson.mobile, this.qdoPerson.email, this.qdo.eqvaRatio, this.qdoPerson.headCodes, this.qdoRef.orgId, this.qdoOrg.orgName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.userId.longValue().eq((Expression)this.qdoRef.userId.longValue()).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)).and((Predicate)this.qdoRef.isCopy.eq((Object)0)).and((Predicate)this.qdoRef.isDefault.eq((Object)0)))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()).and((Predicate)this.qdoOrg.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoPerson)).on((Predicate)this.qdoPerson.id.longValue().eq((Expression)this.qdo.personId.longValue()));
    }

    private JPAQuery<PrdSystemShortcutVO> getJpaQueryShortcutSelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemShortcutVO.class, (Expression[])new Expression[]{this.qdoShortcut.id, this.qdoShortcut.shortcutName, this.qdoShortcut.portalRoute, this.qdoShortcut.shortcutIcon, this.qdoShortcut.sortIndex})).from((EntityPath)this.qdoShortcut);
    }

    public List<PrdSystemShortcutVO> queryShortcutList() {
        JPAQuery<PrdSystemShortcutVO> jpaQuery = this.getJpaQueryShortcutSelect();
        jpaQuery.where((Predicate)this.qdoShortcut.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoShortcut.shortcutStatus.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoShortcut, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdUserCompositeVO> getJpaQueryEmployeeCompositeSelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdUserCompositeVO.class, (Expression[])new Expression[]{this.qdoComposite.id, this.qdoComposite.userId, this.qdoComposite.workType, this.qdoComposite.specialtyLevel, this.qdoComposite.manageLevel})).from((EntityPath)this.qdoComposite);
    }

    public List<PrdUserCompositeVO> queryUserComposite(Long userId) {
        JPAQuery<PrdUserCompositeVO> jpaQuery = this.getJpaQueryEmployeeCompositeSelect();
        jpaQuery.where((Predicate)this.qdoComposite.userId.eq((Object)userId).or((Predicate)this.qdoComposite.userId.eq((Object)-1L)));
        jpaQuery.where((Predicate)this.qdoComposite.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdUserDataVO queryUserDetail(Long userId) {
        JPAQuery<PrdUserDataVO> jpaQuery = this.getJpaQueryEmployeeSelect();
        jpaQuery.where((Predicate)this.qdo.userId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoPerson.deleteFlag.eq((Object)0));
        return (PrdUserDataVO)jpaQuery.fetchFirst();
    }

    public PrdUserDataForAppVO queryUserDetailForApp(Long userId) {
        JPAQuery<PrdUserDataForAppVO> jpaQuery = this.getJpaQueryEmployeeSelectForApp();
        jpaQuery.where((Predicate)this.qdo.userId.eq((Object)userId));
        jpaQuery.where((Predicate)this.qdoPerson.deleteFlag.eq((Object)0));
        return (PrdUserDataForAppVO)jpaQuery.fetchFirst();
    }

    public List<String> queryRolesById(String userId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoRole.roleCode).from((EntityPath)this.qdoRole);
        jpaQuery.where((Predicate)this.qdoRole.roleEmployees.like(SqlUtil.toSqlLikeString(userId)));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdUserDataVO> getJpaQueryEmployeeTicket() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdUserDataVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.pcLoginTicket, this.qdo.employeeNo, this.qdo.employeeName, this.qdoPerson.email})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoPerson)).on((Predicate)this.qdoPerson.id.longValue().eq((Expression)this.qdo.personId.longValue()));
    }

    public PrdUserDataVO queryUserByTicket(String ticket) {
        JPAQuery<PrdUserDataVO> jpaQuery = this.getJpaQueryEmployeeTicket();
        jpaQuery.where((Predicate)this.qdo.pcLoginTicket.eq((Object)ticket));
        jpaQuery.where((Predicate)this.qdoPerson.deleteFlag.eq((Object)0));
        return (PrdUserDataVO)jpaQuery.fetchFirst();
    }

    public long updateTicket(Long id, String ticket) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.pcLoginTicket, (Object)ticket).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        return update.execute();
    }

    public long updateShortcut(Long userId, String shortcutIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.shortcutIds, (Object)shortcutIds).where(new Predicate[]{this.qdo.userId.eq((Object)userId)});
        return update.execute();
    }

    private JPAQuery<PrdSystemMenuVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemMenuVO.class, (Expression[])new Expression[]{this.qdoMenu.id, this.qdoMenu.parentId, this.qdoMenu.menuCode, this.qdoMenu.menuName, this.qdoMenu.menuStatus, this.qdoMenu.portalRoute, this.qdoMenu.menuIcon, this.qdoMenu.sortIndex, this.qdoMenu.remark, this.qdoMenu.deleteFlag, this.qdoMenu.createUserId, this.qdoMenu.createTime})).from((EntityPath)this.qdoMenu);
    }

    public List<PrdSystemMenuVO> queryUsableList() {
        JPAQuery<PrdSystemMenuVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdoMenu.menuStatus.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoMenu, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    public List<Long> queryUserMenuIds(Long userId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoMenu.id).from((EntityPath)this.qdoMenu)).leftJoin((EntityPath)this.qdoRoleMenu)).on((Predicate)this.qdoRoleMenu.menuId.longValue().eq((Expression)this.qdoMenu.id.longValue()))).leftJoin((EntityPath)this.qdoSysRole)).on((Predicate)this.qdoSysRole.id.eq(this.qdoRoleMenu.roleId))).leftJoin((EntityPath)this.qdoUserRole)).on((Predicate)this.qdoUserRole.roleId.eq(this.qdoSysRole.id));
        jpaQuery.where((Predicate)this.qdoMenu.menuStatus.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoMenu.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoSysRole.enabled.eq(Boolean.valueOf(true)));
        jpaQuery.where((Predicate)this.qdoSysRole.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoUserRole.userId.eq((Object)userId));
        return jpaQuery.fetch();
    }

    public PrdUserDAO(JPAQueryFactory jpaQueryFactory, PrdUserRemindRepo userRemindRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.userRemindRepo = userRemindRepo;
    }
}

