package com.elitesland.tw.tw5.server.common.util;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.JWTUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

public class JwtUtil {

    /**
     * 生成token
     * @param keyType 加密类型(不指定默认是HS256)
     * @param payload 例如：
     * {
     *   "jwt": "{\"LoginName\":\"Zhang.Xiao@elitesland.com\",\"UserName\":\"ZhangXiao.zhang@elitesland.com\",\"UserMail\":\"ZhangXiao.zhang@elitesland.com\"}",
     *   "exp": 1684814511
     * }
     * @param secretKey 秘钥
     * @return 返回token
     */
    public static String getToken(String keyType,Map payload,String secretKey){
        //https://blog.csdn.net/qq_36963762/article/details/122338213
        SecureUtil.disableBouncyCastle();
        if(StringUtils.isEmpty(keyType)){
            keyType = "HS256";
        }
        String token = JWT.create().setHeader("alg", keyType).setHeader("typ", "JWT")
                .addPayloads(payload)
                .setKey(secretKey.getBytes())
                .sign();
        return  token;
    }

    /**
     * 解析token
     * @param token
     */
    public static void parseToken(String token){
        JWT jwt = JWTUtil.parseToken(token);
        JWTPayload payload1 = jwt.getPayload();
        System.out.println(JSONUtil.toJsonStr(payload1.toString()));
        Object jwt1 = payload1.getClaim("jwt");
        System.out.println(JSONUtil.toJsonStr(jwt1.toString()));
    }

    /**
     * 验证token
     * @param token
     */
    public static boolean verify(String token,String secretKey){
        return JWTUtil.verify(token, secretKey.getBytes());
    }

//    public static void main(String[] args) {
//        String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqd3QiOiJ7XCJMb2dpbk5hbWVcIjpcIlpoYW5nWGlhby56aGFuZ0BlbGl0ZXNsYW5kLmNvbVwiLFwiVXNlck5hbWVcIjpcIlpoYW5nWGlhby56aGFuZ0BlbGl0ZXNsYW5kLmNvbVwiLFwiVXNlck1haWxcIjpcIlpoYW5nWGlhby56aGFuZ0BlbGl0ZXNsYW5kLmNvbVwifSIsImV4cCI6MTY4NDgxOTkyNH0.EK5DoAqCTcBlW6XduKXLqdXtqfYTjGCy4k1Ho7dpia0";
//        System.out.println(JwtUtil.verify(token,"dfalj-uurw9@%=fjddjfj"));
//        JwtUtil.parseToken(token);
//
//
//    }
}
