package com.elitesland.tw.tw5.server.prd.file.service;

import com.elitesland.tw.tw5.api.prd.file.query.PrdFileVersionQuery;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileRefVO;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVersionVO;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileVersionDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * prd文件版本服务
 *
 * @author duwh
 * @date 2022/09/27
 */
public interface PrdFileVersionService {

    /**
     * 插入
     *
     * @param entity 实体
     * @return {@link PrdFileVersionDO}
     */
    @Transactional(rollbackFor = Exception.class)
    PrdFileVersionDO insert(PrdFileVersionDO entity);

    /**
     * 更新
     *
     * @param entity 实体
     * @return {@link PrdFileVersionDO}
     */
    @Transactional(rollbackFor = Exception.class)
    PrdFileVersionDO update(PrdFileVersionDO entity);

    /**
     * 查询关键
     *
     * @param key 关键
     * @return {@link PrdFileVersionDO}
     */
    PrdFileVersionDO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link PrdFileVersionVO}>
     */
    List<PrdFileVersionVO> queryList(PrdFileVersionQuery query);

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link PrdFileRefVO}>
     */
    PagingVO<PrdFileRefVO> paging(PrdFileVersionQuery query);

    /**
     * 删除软
     *
     * @param keys 键
     */
    @Transactional(rollbackFor = Exception.class)
    void deleteSoft(List<Long> keys);
}
