package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.query.PrdUserMessageQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserMessageService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageTypeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.system.service.PrdMessageConfigServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserMessageDAO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdUserMessageServiceImpl implements PrdUserMessageService {
    private final PrdUserMessageDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigServiceImpl service;

    @Override
    public Long queryTotal() {
        return dao.queryTotal(GlobalUtil.getLoginUserId());
    }

    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {

        dao.deleteSoft(keys, GlobalUtil.getLoginUserId());
        return true;
    }

    @Transactional
    @Override
    public PrdUserMessageVO queryByKey(Long key) {
        PrdUserMessageVO messageVO = dao.queryByKey(key);
        transferSystemSelection(messageVO);
        String name = service.getNoticeSourceName(messageVO.getMessageId(), messageVO.getNoticeScope(), messageVO.getNoticeSource());
        messageVO.setNoticeSourceName(name);
        if (messageVO.getMessageStatus() == 0) {
            List<Long> keys = new ArrayList<>();
            keys.add(key);

            dao.updateStatus(keys, GlobalUtil.getLoginUserId());
        }
        return messageVO;
    }

    @Override
    public PagingVO<PrdUserMessageVO> paging(PrdUserMessageQuery query) {

        PagingVO<PrdUserMessageVO> messageVOPagingVO = dao.queryPaging(query, GlobalUtil.getLoginUserId());
        List<PrdUserMessageVO> configVOS = messageVOPagingVO.getRecords();
        configVOS.forEach(configVO -> transferSystemSelection(configVO));
        return messageVOPagingVO;
    }

    @Transactional
    @Override
    public boolean onKeyUpdateStatus(List<Long> keys) {
        dao.updateStatus(keys, GlobalUtil.getLoginUserId());
        return true;
    }

    @Override
    public List<PrdUserMessageTypeVO> findUnreadMessageTypeList() {
//        List<PrdUserMessageTypeVO> messageTypeList = dao.findMessageTypeList();     // 查询所有消息类型
        // 数据库中没有这类消息的类型也要  m只能写死
        List<PrdUserMessageTypeVO> messageTypeList = new ArrayList<>();
        PrdUserMessageTypeVO prdUserMessageTypeVO = new PrdUserMessageTypeVO();
        prdUserMessageTypeVO.setContentType("systemMessage");
        messageTypeList.add(prdUserMessageTypeVO);
        prdUserMessageTypeVO = new PrdUserMessageTypeVO();
        prdUserMessageTypeVO.setContentType("administrationMessage");
        messageTypeList.add(prdUserMessageTypeVO);
        prdUserMessageTypeVO = new PrdUserMessageTypeVO();
        prdUserMessageTypeVO.setContentType("visit");
        messageTypeList.add(prdUserMessageTypeVO);
        prdUserMessageTypeVO = new PrdUserMessageTypeVO();
        prdUserMessageTypeVO.setContentType("financeMessage");
        messageTypeList.add(prdUserMessageTypeVO);
        prdUserMessageTypeVO = new PrdUserMessageTypeVO();
        prdUserMessageTypeVO.setContentType("companyNotice");
        messageTypeList.add(prdUserMessageTypeVO);
        prdUserMessageTypeVO = new PrdUserMessageTypeVO();
        prdUserMessageTypeVO.setContentType("personnelMessage");
        messageTypeList.add(prdUserMessageTypeVO);
        prdUserMessageTypeVO = new PrdUserMessageTypeVO();
        prdUserMessageTypeVO.setContentType("crm");
        messageTypeList.add(prdUserMessageTypeVO);

        List<PrdUserMessageTypeVO> unreadMessageTypeList = dao.findUnreadMessageTypeList(); //查找所有类型的未读消息集合及数量
        List<PrdUserMessageVO> lastUserMessageList = dao.findLastUserMessage(); //查找所有类型的最新一条的未读消息
        // 将最后一条未读消息 set 进未读消息类型集合
        unreadMessageTypeList.forEach(unreadMessageType -> {
            lastUserMessageList.stream()
                    .filter(prdUserMessageVO -> unreadMessageType.getContentType().equals(prdUserMessageVO.getContentType()))
                    .findFirst()
                    .ifPresent(unreadMessageType::setLastUserMessageVO);
        });
        // 将未读消息类型集合 set 进所有消息类型集合
        messageTypeList.forEach(messageType -> {
            unreadMessageTypeList.stream()
                    .filter(unreadMessageType -> messageType.getContentType().equals(unreadMessageType.getContentType()))
                    .findFirst()
                    .ifPresent(unreadMessageType -> {
                        messageType.setUnreadContentCount(unreadMessageType.getUnreadContentCount());
                        messageType.setLastUserMessageVO(unreadMessageType.getLastUserMessageVO());
                    });
        });
        return messageTypeList;
    }

    @Override
    public List<PrdUserMessageVO> findUnreadMessageListByType(String contentType) {
        List<PrdUserMessageVO> unreadMessageListByType = dao.findUnreadMessageListByType(contentType);
        unreadMessageListByType.forEach(prdUserMessageVO -> transferSystemSelection(prdUserMessageVO));
        return unreadMessageListByType;
    }

    void transferSystemSelection(PrdUserMessageVO vo) {
        vo.setContentTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentType.getCode(), vo.getContentType()));
        vo.setContentBigTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentBigType.getCode(), vo.getContentBigType()));
        vo.setMessageTagName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.MessageTag.getCode(), vo.getMessageTag()));
        vo.setNoticeScopeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.NoticeScope.getCode(), vo.getNoticeScope()));
    }
}
