package com.elitesland.tw.tw5.server.prd.ab.dao;


import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbContactsPayload;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdAbContactsQuery;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbContactsVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbContactsDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
//import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbContactsDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbContactsRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class PrdAbContactsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbContactsRepo repo;
    private final QPrdAbContactsDO qdo = QPrdAbContactsDO.prdAbContactsDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;
//    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.contactsIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.contactsIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

//    /**
//     * @param bookId
//     * @return
//     * @Description
//     **/
//    public Long queryIdByBookId(Long bookId) {
//        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoCustomer.id).from(qdoCustomer);
//        jpaQuery.where(qdoCustomer.bookId.eq(bookId));
//        jpaQuery.where(qdoCustomer.deleteFlag.eq(0));
//        return jpaQuery.fetchFirst();
//    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdAbContactsDO save(PrdAbContactsDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdAbContactsVO> getJpaQuerySelect() {
        JPAQuery<PrdAbContactsVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdAbContactsVO.class,
                qdo.id,
                qdo.bookId,
                qdoAb.bookName,
                qdo.contactsType,
                qdo.contactsName,
                qdo.contactsPhone,
                qdo.contactsTelephone,
                qdo.contactsEmail,
                qdo.contactsAddress,
                qdo.socialAccountType,
                qdo.socialAccount,
                qdo.contactsDepartment,
                qdo.contactsPosition,
                qdo.contactsStatus,
                qdo.contactsNo,
                qdo.sex,
                qdo.birthday,
                qdo.isKeyPerson,
                qdo.remark
        )).from(qdo).leftJoin(qdoAb).on(qdoAb.id.longValue().eq(qdo.bookId.longValue()));
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdAbContactsVO> getJpaQueryWhere(PrdAbContactsQuery query) {
        JPAQuery<PrdAbContactsVO> jpaQuery = getJpaQuerySelect();
        if(!ObjectUtils.isEmpty(query.getContactsIds())){
            jpaQuery.where(qdo.id.in(query.getContactsIds()));
        }
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            jpaQuery.where(qdo.bookId.eq(query.getBookId()));
        }
        if (!ObjectUtils.isEmpty(query.getContactsName())) {
            jpaQuery.where(qdo.contactsName.like(SqlUtil.toSqlLikeString(query.getContactsName())));
        }
        if (!ObjectUtils.isEmpty(query.getContactsType())) {
            jpaQuery.where(qdo.contactsType.eq(query.getContactsType()));
        }
        if (!ObjectUtils.isEmpty(query.getContactsStatus())) {
            jpaQuery.where(qdo.contactsStatus.eq(query.getContactsStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getIsKeyPerson())) {
            jpaQuery.where(qdo.isKeyPerson.eq(query.getIsKeyPerson()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdAbContactsVO> queryPaging(PrdAbContactsQuery query) {
        JPAQuery<PrdAbContactsVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdAbContactsVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdAbContactsVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * @param bookId 地址簿主键
     * @return
     * @Description 主键查询
     **/
    public List<PrdAbContactsVO> queryList(Long bookId) {
        JPAQuery<PrdAbContactsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public PrdAbContactsVO queryByKey(Long key) {
        JPAQuery<PrdAbContactsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdAbContactsPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getBookId() != null) {
            update.set(qdo.bookId, payload.getBookId());
        }
        if (payload.getContactsStatus() != null) {
            update.set(qdo.contactsStatus, payload.getContactsStatus());
        }
        if (payload.getContactsType() != null) {
            update.set(qdo.contactsType, payload.getContactsType());
        }
        if (payload.getContactsName() != null) {
            update.set(qdo.contactsName, payload.getContactsName());
        }
        if (payload.getContactsPhone() != null) {
            update.set(qdo.contactsPhone, payload.getContactsPhone());
        }
        if (payload.getContactsTelephone() != null) {
            update.set(qdo.contactsTelephone, payload.getContactsTelephone());
        }
        if (payload.getContactsEmail() != null) {
            update.set(qdo.contactsEmail, payload.getContactsEmail());
        }
        if (payload.getContactsAddress() != null) {
            update.set(qdo.contactsAddress, payload.getContactsAddress());
        }
        if (payload.getSocialAccountType() != null) {
            update.set(qdo.socialAccountType, payload.getSocialAccountType());
        }
        if (payload.getSocialAccount() != null) {
            update.set(qdo.socialAccount, payload.getSocialAccount());
        }

        if (payload.getContactsDepartment() != null) {
            update.set(qdo.contactsDepartment, payload.getContactsDepartment());
        }
        if (payload.getContactsPosition() != null) {
            update.set(qdo.contactsPosition, payload.getContactsPosition());
        }
        if (payload.getSex() != null) {
            update.set(qdo.sex, payload.getSex());
        }
        if (payload.getBirthday() != null) {
            update.set(qdo.birthday, payload.getBirthday());
        }
        if (payload.getIsKeyPerson() != null) {
            update.set(qdo.isKeyPerson, payload.getIsKeyPerson());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 修改状态
     *
     * @param key    主键
     * @param status 状态
     * @return
     */
    public long updateStatus(Long key, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(key));
        update.set(qdo.contactsStatus, status);
        return update.execute();
    }

    /**
     * @param bookId 地址簿
     * @return
     * @Description
     **/
    public String queryOaName(Long bookId) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdoAb.bookName).from(qdoAb);
        jpaQuery.where(qdoAb.id.eq(bookId));
        jpaQuery.where(qdoAb.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

}
