package com.elitesland.tw.tw5.server.prd.common;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.server.common.NotOnlineException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@Component
@RequiredArgsConstructor
public class GlobalUtil {
    private final CacheUtil cacheUtil;
    public final static ObjectMapper objectMapper = new ObjectMapper();

    /**
     * 获取当前租户id
     *
     * @return
     */
    public static Long getTenantId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "获取用户数据失败");
        }
        return user.getUser().getTenantId();
    }

    /**
     * 获取当前登录人用户信息
     *
     * @return
     */
    public static SysUserDTO getLoginUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "获取用户数据失败");
        }
        return user.getUser();
    }

    /**
     * 获取当前登录人用户信息
     *
     * @return
     */
    public static GeneralUserDetails getLoginGeneralUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "获取用户数据失败");
        }
        return user;
    }

    /**
     * 获取当前登录人userId
     *
     * @return
     */
    public static Long getLoginUserId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "获取用户数据失败");
        }
        return user.getUser().getId();
    }

    /**
     * 获取当前登录人姓名
     *
     * @return
     */
    public static String getLoginUserName() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "获取用户数据失败");
        }
        String firstName = user.getUser().getFirstName();
        if (!StringUtils.hasText(firstName)) {
            firstName = user.getUser().getLastName();
        }
        return firstName;
    }

    /**
     * 返回用户的系统角色编码
     *
     * @param userId 用户id
     * @return
     */
    public List<String> getSystemRoleCodesCache(Long userId) {
       return cacheUtil.getSystemRoleCodesCache(userId);
    }

    /**
     * 返回用户的系统角色编码
     *
     * @param userId 用户id
     * @return
     */
    public List<String> getSystemRoleCodes(Long userId) {
        return cacheUtil.getSystemRoleCodes(userId);
    }

    /**
     * 功能权限的校验，判断有没有操作权限
     *
     * @param url
     * @return
     * @throws JSONException
     */
    public boolean checkOperateUrl(String url) throws JSONException {
        PrdSystemFunctionSpecialVO vo = cacheUtil.getFunctionSpecial(url);
        if (vo != null) {
            String roles = vo.getSpecialRoles();
            if (roles != null && roles != "") {
                JSONObject jsonObject = new JSONObject().getJSONObject(roles);
                GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
                if (userDetails != null) {
                    SysUserDTO user = userDetails.getUser();
                    Long userId = user.getId();
                    //允许操作的系统用户中是否包含该用户
                    if (jsonObject.getString("1").contains(userId + "")) {
                        return true;
                    }
                    //允许操作的系统角色中是否包含该用户所拥有的角色
                    String rolesStr = jsonObject.getString("2");
                    Set<SysRoleVO> userRoles = user.getRoles();
                    for (SysRoleVO role : userRoles) {
                        if (rolesStr.contains(role.getId() + "")) {
                            return true;
                        }
                    }
                    //TODO 判断允许操作的岗位中是否包含该用户所拥有的岗位


                }


            } else {
                return true;
            }
        } else {
            return true;
        }

        return false;
    }

    /**
     * 数据合并
     *
     * @param origin      源数据（需要合并的数据）
     * @param destination 目标数据（需要被合并的数据）
     * @param <T>
     */
    public static <T> void mergeObject(T origin, T destination) {
        if (origin == null || destination == null) {
            return;
        }
        if (!origin.getClass().equals(destination.getClass())) {
            return;
        }

        Field[] fields = origin.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            try {
                fields[i].setAccessible(true);
                Object value = fields[i].get(origin);
                if (null != value) {
                    fields[i].set(destination, value);
                }
                fields[i].setAccessible(false);
            } catch (Exception e) {
            }
        }
    }
//    /**
//     * 数据权限的校验，判断有没有该条数据的操作权限
//     *
//     * @param
//     * @return
//     * @throws JSONException
//     */
//    public boolean checkUpdatePermission(String path, TwCommonPayload twCommonPayload) throws JSONException {
//        PrdSystemFunctionVO vo = cacheUtil.getFunction(path);
//        if (vo != null) {
//            GeneralUserDetails user = SecurityUtil.getUser();
//            List<PrdSystemFunctionDataVO> list = cacheUtil.getFunctionData(vo.getId());
//
//            for (PrdSystemFunctionDataVO prdSystemFunctionDataVO : list) {
//                if (prdSystemFunctionDataVO.getFunctionDataType() > PrdSystemFunctionDataVO.FUNCTION_LOOK) {
//
//                    if (prdSystemFunctionDataVO.getFunctionPermissionType() == 1) {
//                        //TODO 判断模块权限允许操作的角色中是否包含用户角色
//                        return true;
//
//                    } else {
//                        // 判断该用户有没有该数据行权限
//
//                        Long userId = (Long) getFileValue(prdSystemFunctionDataVO.getFunctionFieldName(), twCommonPayload);
//                        if (userId == user.getUser().getId()) {
//                            return true;
//                        }
//                    }
//
//
//                }
//
//            }
//        }
//
//
//        return false;
//    }

    /**
     * 数据权限的校验，判断有没有该条数据的删除权限
     *
     * @param url
     * @return
     * @throws JSONException
     */
    public boolean checkDeletePermission(String url) throws JSONException {


        return true;
    }

    /**
     * 数据权限的校验，判断有没有该条数据的删除权限
     *
     * @param url
     * @return
     * @throws JSONException
     */
    public boolean checkLookPermission(String url) throws JSONException {
        return true;
    }

    Object getFileValue(String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * json对象转json字符串
     *
     * @param response
     */
    public static void responseJson(HttpServletResponse response) {
        try {
            String json = getJson(TwOutputUtil.ok());
            response.getWriter().write(json);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getJson(Object obj) {
        String json = null;
        try {
            json = objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    /**
     * 替换文本中的html标签
     *
     * @param str
     * @return
     * @throws PatternSyntaxException
     */
    public static String stringHtmlFilter(String str) throws PatternSyntaxException {

        String regEx = "(?!<(br|a|/a).*?>)<.*?>";
        Pattern p_html = Pattern.compile(regEx, Pattern.CASE_INSENSITIVE);
        Matcher m_html = p_html.matcher(str);
        str = m_html.replaceAll("");

        return str; // 返回文本字符串
    }

    public static String getContantsLog(String detail, String oldName, String newName, String oldPhone, String newPhone) {
        if (newName == null) {

        } else if (oldName == null && newName != null) {
            detail += " 联系人由 -" + " 修改为 " + newName;
//        } else if (newName == null && oldName != null) {
//            detail += " 联系人由 " + oldName + " 修改为 -";
        } else if (!newName.equals(oldName)) {
            detail += " 联系人由 " + oldName + " 修改为 " + newName;
        }
        if (newPhone == null) {
            // return detail;
        } else if (oldPhone == null && newPhone != null) {
            detail += " 联系人电话由 -" + " 修改为 " + newPhone;
//        } else if (newPhone == null && oldPhone != null) {
//            detail += " 联系人电话由 " + oldPhone + " 修改为 -";
        } else if (!newPhone.equals(oldPhone)) {
            detail += " 联系人电话由 " + oldPhone + " 修改为 " + newPhone;
        }
        return detail;
    }

    /**
     * list拆分
     *
     * @param list
     * @param subNum 每个list长度
     * @param <T>
     * @return
     */
    public static <T> List<List<T>> splistList(List<T> list, int subNum) {
        List<List<T>> tNewList = new ArrayList<List<T>>();
        int priIndex = 0;
        int lastPriIndex = 0;
        int insertTimes = list.size() / subNum;
        List<T> subList = new ArrayList<>();
        for (int i = 0; i <= insertTimes; i++) {
            priIndex = subNum * i;
            lastPriIndex = priIndex + subNum;
            if (i == insertTimes) {
                subList = list.subList(priIndex, list.size());
            } else {
                subList = list.subList(priIndex, lastPriIndex);
            }
            if (subList.size() > 0) {
                tNewList.add(subList);
            }
        }
        return tNewList;
    }
}
