package com.elitesland.tw.tw5.server.prd.office.models.configurations;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@Component
@Scope("prototype")
@Getter
@Setter
public class Info {  // the additional parameters for the document (document owner, folder where the document is stored, uploading date, sharing settings)
    private String owner = "EL";  // the name of the document owner/creator
    private Boolean favorite = null;  // the highlighting state of the Favorite icon
    private String uploaded = getDate();  // the document uploading date

    private String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd yyyy", Locale.US);
        return simpleDateFormat.format(new Date());
    }
}
