package com.elitesland.tw.tw5.server.prd.org.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;

/**
 * 组织管理
 *
 * @author wangding
 */
@Api("组织管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgOrganizationController {
    private final PrdOrgOrganizationService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/org/insert")
    public TwOutputUtil insert(PrdOrgOrganizationPayload entity) {
        PrdOrgOrganizationVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/org/update")
    public TwOutputUtil update(PrdOrgOrganizationPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 修改状态
     *
     * @param id        组织主键id
     * @param orgStatus 组织状态
     * @return result
     */
    @ApiOperation("修改状态")
    @PutMapping("/org/updateStatus")
    public TwOutputUtil updateStatus(Long id, String orgStatus) {
        service.updateStatus(id, orgStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 全局修改组织树修关系
     *
     * @param payloadStrs po集合类
     * @return result
     */
    @ApiOperation("全局修改组织树修关系")
    @PutMapping("/org/updateAllRef")
    public TwOutputUtil updateAllRef(String payloadStrs) {
        service.updateOrgOrEmpRef(JSONObject.parseArray(payloadStrs, PrdOrgOrganizationDataPayload.class));
        return TwOutputUtil.ok();
    }

    /**
     * 修改父组织
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("修改父组织")
    @PutMapping("/org/updateRef")
    public TwOutputUtil updateRef(PrdOrgOrganizationRefPayload payload) {
        service.updateRef(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 组织引用
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("组织引用")
    @PutMapping("/org/reference")
    public TwOutputUtil reference(PrdOrgOrganizationRefPayload payload) {
        service.reference(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 组织逻辑删除
     *
     * @param dimensionId 维度id
     * @param orgId       组织id
     * @return result
     */
    @ApiOperation("组织逻辑删除")
    @DeleteMapping("/org/delete")
    public TwOutputUtil delete(Long dimensionId, Long orgId) {
        service.deleteSoft(dimensionId, orgId);
        return TwOutputUtil.ok();

    }

    /**
     * 根据维度id组织列表查询
     *
     * @param dimensionId
     * @return result
     */
    @ApiOperation("根据维度id组织列表查询")
    @GetMapping("/org/list")
    public TwOutputUtil queryList(Long dimensionId) {
        List<PrdOrgOrganizationRefVO> vo = service.queryList(dimensionId);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页条件查询
     *
     * @return result
     */
    @ApiOperation("分页条件查询")
    @GetMapping("/org/pading")
    public TwOutputUtil queryPading(PrdOrgOrganizationQuery query) {
        PagingVO<PrdOrgOrganizationVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 根据组织id查询组织下员工
     *
     * @param orgId 组织id
     * @return result
     */
    @ApiOperation("根据组织id查询组织下员工")
    @GetMapping("/org/queryEmployeeRefList")
    public TwOutputUtil queryEmployeeRefList(Long orgId) {
        List<PrdOrgEmployeeRefVO> vo = service.queryEmployeeRefList(orgId);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 查询所有可用组织
     *
     * @param dimensionId 维度id (不在该维度下的所有可用组织)
     * @param defaultFlag 是否取默认维度有效组织
     * @return result
     */
    @ApiOperation("查询所有可用组织")
    @GetMapping("/org/queryAll")
    public TwOutputUtil queryAll(Long dimensionId, Boolean defaultFlag) {
        List<PrdOrgOrganizationRefVO> vo = service.queryAll(dimensionId, defaultFlag);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 根据主键和维度组织详情查询
     *
     * @param dimensionId 维度Id
     * @param orgId       组织Id
     * @return result
     */
    @ApiOperation("根据主键和维度组织详情查询")
    @GetMapping("/org/detail")
    public TwOutputUtil queryDetail(Long dimensionId, Long orgId) {
        PrdOrgOrganizationVO vo = service.queryDetail(dimensionId, orgId);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 添加组织员工
     *
     * @param payloadStrs PrdOrgEmployeeRefPayload类字符串
     * @return result
     */
    @ApiOperation("添加组织员工")
    @PostMapping("/org/insertEmployee")
    public TwOutputUtil insertEmployeeRef(String payloadStrs) {
        service.insertEmployeeRef(JSONObject.parseArray(payloadStrs, PrdOrgEmployeeRefPayload.class));
        return TwOutputUtil.ok();
    }


    /**
     * 移除组织员工
     *
     * @param orgId   组织id
     * @param userIds 员工ids
     * @return result
     */
    @ApiOperation("移除组织员工")
    @PutMapping("/org/deleteEmployee")
    public TwOutputUtil deleteEmployee(Long orgId, Long[] userIds) {
        service.deleteEmployeeRefSoft(orgId, Arrays.asList(userIds));
        return TwOutputUtil.ok();
    }

    /**
     * 新建或修改组织角色
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("修改组织角色")
    @PutMapping("/org/updateRole")
    public TwOutputUtil updateRole(PrdOrgRolePayload payload) {
        service.updateRole(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 删除组织角色
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("删除组织角色")
    @DeleteMapping("/org/deleteRole/{key}")
    public TwOutputUtil deleteRoleSoft(@PathVariable Long key) {
        service.deleteRoleSoft(key);
        return TwOutputUtil.ok();
    }


    @PostMapping("/org/syncFromV4")
    public TwOutputUtil syncFromV4(@RequestBody List<PrdOrgOrganizationPayload> orgOrganizationPayloads) {
        System.out.println(orgOrganizationPayloads);
        return TwOutputUtil.ok(log);
    }

    @ApiOperation("批量导入excel")
    @PostMapping(value = "org/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    @GlobalTransactional
    public TwOutputUtil batchImport(MultipartFile file) {
        service.importOrganization(file);
        return TwOutputUtil.ok();
    }



}
