package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.*;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeRefConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgOrganizationConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgRoleConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.time.LocalDate;
import java.util.*;

/**
 * 维度管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgOrganizationServiceImpl implements PrdOrgOrganizationService {

    final String default_role_Code = "ORG-LEADER";
    private final PrdOrgOrganizationDAO dao;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationRefRepo repo;
    private final CacheUtil cacheUtil;
    @Value("${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;

    @Transactional
    @Override
    public PrdOrgOrganizationVO insert(PrdOrgOrganizationPayload payload) {

        int count = dao.queryAll(payload.getOrgCode(), null, null).size();
        if (count > 0) {
            throw TwException.error("", "编号不可重复");
        }
        PrdOrgOrganizationDO ado = PrdOrgOrganizationConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        refDao.setOrgId(ado.getId());
        refDao.setDimensionId(ado.getDimensionId());
        refDao.setOrgType(1);
        refDao.setParentId(payload.getParentId());

        dao.saveRef(refDao);
        //创建组织默认角色
        PrdOrgRoleDO roleDO = new PrdOrgRoleDO();
        roleDO.setOrgId(ado.getId());
        roleDO.setRoleCode(default_role_Code);
        roleDO.setRoleName("组织负责人");
        if (payload.getManageId() != null && payload.getManageId().longValue() != 0) {
            roleDO.setRoleEmployees(payload.getManageId() + "");
        }
        dao.saveRole(roleDO);
        return PrdOrgOrganizationConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public PrdOrgOrganizationVO insertByTenant(PrdOrgOrganizationPayload payload) {

        int count = dao.queryAll(payload.getOrgCode(), null, null).size();
        if (count > 0) {
            throw TwException.error("", "编号不可重复");
        }
        PrdOrgOrganizationDO ado = PrdOrgOrganizationConvert.INSTANCE.toDo(payload);
        // 租户初始化数据
        if (null != payload.getInitTenantId()) {
            ado.setTenantId(payload.getInitTenantId());
        }
        ado = dao.save(ado);
        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        refDao.setOrgId(ado.getId());
        refDao.setDimensionId(ado.getDimensionId());
        refDao.setOrgType(1);
        refDao.setParentId(payload.getParentId());

        // 租户初始化数据
        if (null != payload.getInitTenantId()) {
            refDao.setTenantId(payload.getInitTenantId());
        }

        dao.saveRef(refDao);
        //创建组织默认角色
        PrdOrgRoleDO roleDO = new PrdOrgRoleDO();
        roleDO.setOrgId(ado.getId());
        roleDO.setRoleCode(default_role_Code);
        roleDO.setRoleName("组织负责人");
        if (payload.getManageId() != null && payload.getManageId().longValue() != 0) {
            roleDO.setRoleEmployees(payload.getManageId() + "");
        }
        // 租户初始化数据
        if (null != payload.getInitTenantId()) {
            roleDO.setTenantId(payload.getInitTenantId());
        }

        dao.saveRole(roleDO);
        return PrdOrgOrganizationConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(PrdOrgOrganizationPayload payload) {
        if (payload.getParentId() != null && payload.getParentId().longValue() == payload.getId().longValue()) {
            throw TwException.error("", "上级组织不可选择自身组织");
        }
        List<PrdOrgOrganizationRefVO> refVOS = dao.queryAll(payload.getOrgCode(), null, null);
        if (refVOS.size() == 0 || (refVOS.size() == 1 && refVOS.get(0).getOrgId().longValue() == payload.getId().longValue())) {
            PrdOrgOrganizationRefVO ovo = dao.queryByRefId(payload.getId());
            if (ovo != null && ovo.getDimensionId().longValue() == payload.getDimensionId().longValue()) {
                if (payload.getParentId() != null && payload.getParentId().longValue() > 0) {
                    PrdOrgOrganizationRefPayload refPayload = new PrdOrgOrganizationRefPayload();
                    refPayload.setOrgId(payload.getId());
                    refPayload.setDimensionId(payload.getDimensionId());
                    refPayload.setParentId(payload.getParentId());
                    dao.updateRef(refPayload);
                }
                if (payload.getManageId() != null && payload.getManageId().longValue() != 0) {
                    dao.updateRoleEmployees(payload.getId(), default_role_Code, payload.getManageId() + "");
                }
                //更新主表
                return dao.updateByKeyDynamic(payload);
            } else {
                throw TwException.error("", "编号不可重复");
            }
        } else {
            throw TwException.error("", "引用组织不可编辑");
        }

    }

    @Transactional
    @Override
    public Long updateRef(PrdOrgOrganizationRefPayload payload) {
        return dao.updateRef(payload);
    }

    @Transactional
    @Override
    public Long reference(PrdOrgOrganizationRefPayload payload) {
        if (payload.getParentId().longValue() == payload.getOrgId().longValue()) {
            throw TwException.error("", "引用组织关系错误");
        }
        PrdOrgOrganizationRefDO ordo = dao.queryByDimensionIdOrOrgId(payload.getDimensionId(), payload.getOrgId());
        if (ordo != null) {
            if (ordo.getOrgType().intValue() == 2) {
                throw TwException.error("", "当前维度下已存在该组织引用关系");
            }
        }
        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        refDao.setParentId(payload.getParentId());
        refDao.setOrgId(payload.getOrgId());
        refDao.setOrgType(2);
        refDao.setDimensionId(payload.getDimensionId());
        dao.saveRef(refDao);
        return 0L;
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long dimensionId, Long orgId) {
        PrdOrgOrganizationRefDO ordo = dao.queryByDimensionIdOrOrgId(dimensionId, orgId);
        if (ordo != null) {
            if (ordo.getOrgType().intValue() == 2) {
                //表示删除引用关系，只要删除关系表即可
                dao.deleteRefSoft(ordo.getId());
                return true;
            } else {
                PrdOrgOrganizationDO organizationDO = dao.queryById(orgId);
                //首先判断该组织是否是激活状态，如果是激活状态的话不能删除
                if (!organizationDO.getOrgStatus().equalsIgnoreCase("active")) {
                    PrdOrgOrganizationRefDO organizationRefDO = dao.queryFirstByParentId(orgId);
                    //判断该组织是否有下属组织
                    if (organizationRefDO == null) {
                        List<PrdOrgEmployeeRefVO> empList = dao.queryEmployeeList(orgId);
                        //判断该组织是否有下属员工
                        if (empList == null || empList.size() == 0) {
                            //表示删除归属，删除所有该组织关系并删除组织
                            dao.deleteAllRefSoft(orgId);
                            dao.deleteSoft(orgId);
                            return true;
                        }

                    }
                }
            }
        }
        throw TwException.error("", "删除失败，该组织已激活或存在下属关系");
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryList(Long dimensionId) {
        if (dimensionId == null) {
            dimensionId = default_dimension_id;
        }
        List<PrdOrgOrganizationRefVO> organizationRefVOS = dao.queryOrgList(dimensionId,null);
        for (PrdOrgOrganizationRefVO rvo : organizationRefVOS) {
            List<PrdOrgEmployeeRefVO> refVOS = dao.queryEmployeeList(rvo.getOrgId());
            if (rvo.getManageId() != null) {
                Optional<PrdOrgEmployeeRefVO> first = refVOS.stream().filter(a -> (rvo.getManageId().longValue() == a.getUserId().longValue())).findFirst();
                if (!first.isEmpty()) {
                    first.get().setIsManage(0);
                }
            }
            rvo.setOrgEmployees(refVOS);
        }
        return organizationRefVOS;
    }

    @Override
    public List<PrdOrgOrganizationRefVO> queryAll(Long dimensionId, Boolean defaultFlag) {

        return dao.queryAll(null, dimensionId, defaultFlag);
    }

    @Override
    public PagingVO<PrdOrgOrganizationVO> paging(PrdOrgOrganizationQuery query) {

        return dao.queryPaging(query);
    }

    @Override
    public List<PrdOrgEmployeeRefVO> queryEmployeeRefList(Long orgId) {
        return dao.queryEmployeeList(orgId);
    }

//    @Override
//    public PrdOrgOrganizationVO queryOrgById(Long id) {
//        PrdOrgOrganizationVO ovo = dao.queryOrgById(id);
//        if (ovo != null) {
//            List<PrdOrgRoleVO> roleVos = dao.queryRoleList(id);
//            if (roleVos != null && roleVos.size() > 0) {
//                for (PrdOrgRoleVO role : roleVos) {
//                    if (!ObjectUtils.isEmpty(role.getRoleEmployees())) {
//                        String[] employeeStrs = role.getRoleEmployees().split(",");
//                        List<Long> employeeIds = new ArrayList<>();
//                        for (int i = 0; i < employeeStrs.length; i++) {
//                            employeeIds.add(Long.valueOf(employeeStrs[i]));
//                        }
//                        role.setOrgEmployees(dao.queryRoleEmployeeList(employeeIds));
//                    }
//                }
//            }
//            ovo.setOrgRoles(roleVos);
//            String selcetKey = "org:manage:status";
//            PrdSystemSelectionVO view = cacheUtil.getSystemSelection(selcetKey);
//            if (view != null && view.getChildren() != null && !view.getChildren().isEmpty()) {
//                List<PrdSystemSelectionVO> childrens = view.getChildren();
//                for (PrdSystemSelectionVO selectionVO : childrens) {
//                    if (selectionVO.getSelectionValue().equalsIgnoreCase(ovo.getOrgStatus())) {
//                        ovo.setOrgStatusName(selectionVO.getSelectionName());
//                        break;
//                    }
//                }
//            }
//            return ovo;
//        }
//        return null;
//    }

    @Override
    public PrdOrgOrganizationVO queryDetail(Long dimensionId, Long orgId) {
        PrdOrgOrganizationRefDO ordo = dao.queryByDimensionIdOrOrgId(dimensionId, orgId);
        if (ordo != null) {
            PrdOrgOrganizationVO ovo = dao.queryOrgById(orgId);
            ovo.setOrgType(ordo.getOrgType());
            ovo.setParentId(ordo.getParentId());
            if (ovo != null) {
                List<PrdOrgRoleVO> roleVos = dao.queryRoleList(orgId);
                for (PrdOrgRoleVO role : roleVos) {
                    if (!ObjectUtils.isEmpty(role.getRoleEmployees())) {
                        String[] employeeStrs = role.getRoleEmployees().split(",");
                        List<Long> employeeIds = new ArrayList<>();
                        for (int i = 0; i < employeeStrs.length; i++) {
                            employeeIds.add(Long.valueOf(employeeStrs[i]));
                        }
                        role.setOrgEmployees(dao.queryRoleEmployeeList(employeeIds));
                    }
                }
                ovo.setOrgRoles(roleVos);
                String selcetKey = "org:manage:status";
                PrdSystemSelectionVO view = cacheUtil.getSystemSelection(selcetKey);
                if (view != null && view.getChildren() != null && !view.getChildren().isEmpty()) {
                    List<PrdSystemSelectionVO> childrens = view.getChildren();
                    for (PrdSystemSelectionVO selectionVO : childrens) {
                        if (selectionVO.getSelectionValue().equalsIgnoreCase(ovo.getOrgStatus())) {
                            ovo.setOrgStatusName(selectionVO.getSelectionName());
                            break;
                        }
                    }
                }
                return ovo;
            }
        }

        return null;
    }

    @Override
    public PrdOrgOrganizationVO queryDetailSimpleByOrgId(Long orgId) {
        final PrdOrgOrganizationDO prdOrgOrganizationDO = dao.queryById(orgId);
        final PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
        return prdOrgOrganizationVO;
    }

    @Transactional
    @Override
    public Long insertEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads) {

        List<Long> employeeIds = new ArrayList<>();
        List<Long> employeeRemoveIds = new ArrayList<>();

        List<PrdOrgEmployeeRefDO> employeeRefDOs = new ArrayList<>();
        for (PrdOrgEmployeeRefPayload payload : payloads) {
            if (payload.getParentId().longValue() == payload.getUserId().longValue()) {
                throw TwException.error("", "提交上级数据异常");
            }
            PrdOrgEmployeeRefDO ado = dao.queryByOrgIdAndEmpId(payload.getOrgId(), payload.getUserId());
            if (ado == null) {
                if (payload.getIsDefault() == 0) {
                    employeeIds.add(payload.getUserId());
                }
                if (payload.getIsRemove() == 0) {
                    employeeRemoveIds.add(payload.getUserId());
                }
                ado = PrdOrgEmployeeRefConvert.INSTANCE.toDo(payload);
                ado.setJoinDate(LocalDate.now());
                employeeRefDOs.add(ado);
            }
        }
        if (employeeRemoveIds.size() > 0) {
            dao.updateEmployeeRefFlag(employeeRemoveIds);
        }
        if (employeeIds.size() > 0) {
            dao.updateEmployeeRefStatus(employeeIds);
        }
        if (employeeRefDOs.size() > 0) {
            dao.saveEmployeeRef(employeeRefDOs);
        }
        return 0L;
    }

    @Transactional
    @Override
    public boolean deleteEmployeeRefSoft(Long orgId, List<Long> userIds) {
        long num = dao.deleteEmployeeRefSoft(orgId, userIds);
        if (num < userIds.size()) {
            throw TwException.error("", "员工默认组织不可被移除");
        }
        return true;
    }

    @Transactional
    @Override
    public PrdOrgRoleVO insertRole(PrdOrgRolePayload payload) {
        PrdOrgRoleDO ado = PrdOrgRoleConvert.INSTANCE.toDo(payload);
        dao.saveRole(ado);
        return PrdOrgRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long updateRole(PrdOrgRolePayload payload) {
        if (payload.getRoleCode() != null && !payload.getRoleCode().equals(default_role_Code)) {
            if (payload.getId() == null || payload.getId().longValue() == 0 || dao.queryRoleByKey(payload.getId()) == null) {
                PrdOrgRoleDO ado = PrdOrgRoleConvert.INSTANCE.toDo(payload);
                dao.saveRole(ado);
            } else {
                dao.updateRole(payload);
            }
        }
        return 0L;
    }

    @Transactional
    @Override
    public Boolean deleteRoleSoft(Long key) {
        return dao.deleteRoleSoft(key) >= 0;
    }

    @Transactional
    @Override
    public Long updateStatus(Long id, String orgStatus) {
        if (id != null && StringUtils.hasText(orgStatus)) {
            if (orgStatus.equalsIgnoreCase("active")) {
                PrdOrgOrganizationVO pvo = dao.queryParentOrgById(id);
                if (pvo != null && !pvo.getOrgStatus().equalsIgnoreCase("active")) {
                    throw TwException.error("", "上级组织是非激活状态");
                }
            }
            dao.updateStatus(id, orgStatus);
        } else {
            throw TwException.error("", "参数错误 id：" + id + " orgStatus：" + orgStatus);
        }
        return 0L;
    }

    @Transactional
    @Override
    public Long updateOrgOrEmpRef(List<PrdOrgOrganizationDataPayload> payloads) {
        List<Long> orgRefIds = new ArrayList<>();
        List<Long> empRefIds = new ArrayList<>();
        Map<Long, PrdOrgOrganizationDataPayload> mapDatas = new HashMap<>();
        for (PrdOrgOrganizationDataPayload payload : payloads) {
            if (payload.getDataType().equals("org")) {
                orgRefIds.add(payload.getId());
            } else {
                empRefIds.add(payload.getId());
            }
            mapDatas.put(payload.getId(), payload);
        }

        List<PrdOrgOrganizationRefDO> orgRefDOs = new ArrayList<>();
        if (orgRefIds.size() > 0) {
            orgRefDOs = dao.queryByOrgRefIds(orgRefIds);
        }
        for (PrdOrgOrganizationRefDO orgRefDO : orgRefDOs) {
            PrdOrgOrganizationDataPayload payload = mapDatas.get(orgRefDO.getId());
            Long parentId = orgRefDO.getParentId() == null ? 0L : orgRefDO.getParentId();
            if (payload.getChangeId().longValue() != parentId.longValue() || payload.getSortIndex().intValue() != orgRefDO.getSortIndex().intValue()) {
                orgRefDO.setParentId(payload.getChangeId());
                orgRefDO.setSortIndex(payload.getSortIndex());
                dao.updateOrgRef(orgRefDO);
            }
        }
        List<PrdOrgEmployeeRefDO> employeeRefDOs = new ArrayList<>();
        if (empRefIds.size() > 0) {
            employeeRefDOs = dao.queryByEmployeeRefIds(empRefIds);
        }
        for (PrdOrgEmployeeRefDO empRefDO : employeeRefDOs) {
            PrdOrgOrganizationDataPayload payload = mapDatas.get(empRefDO.getId());
            if (payload.getChangeId().longValue() != empRefDO.getOrgId().longValue() || payload.getSortIndex().intValue() != empRefDO.getSortIndex().intValue()) {
                empRefDO.setOrgId(payload.getChangeId());
                empRefDO.setSortIndex(payload.getSortIndex());
                dao.updateEmployeeRef(empRefDO);
            }
        }

        return 0L;
    }

    @Override
    public Map<Long, String> queryOrgs(List<Long> orgIds) {
        List<Map<String, Object>> orgs = dao.queryOrgs(orgIds);
        Map<Long, String> orgMap = new HashMap<>();
        orgs.forEach(org -> orgMap.put(Long.valueOf(org.get("id") + ""), (String) org.get("orgName")));
        return orgMap;
    }

    @Override
    public Map<Long, Long> getV4AndV5OrgIds() {
        Map<Long,Long> orgMap = new HashMap<>();
        //查询公司列表
        List<Map<String,Object>> v4AndV5OrgIds = dao.getV4AndV5OrgIds();
        for (Map<String, Object> v4AndV5OrgId : v4AndV5OrgIds) {
            Long orgId = (Long) v4AndV5OrgId.get("orgId");
            Long orgIdV4 = (Long) v4AndV5OrgId.get("orgIdV4");
            if(orgId!=null && orgIdV4!=null){
                orgMap.put(orgIdV4,orgId);
            }
        }
        return orgMap;
    }

    /**
     * 批量导入excle
     *
     * @param file
     */
    @Transactional
    @Override
    public void importOrganization(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("组织数据");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        ArrayList<PrdOrgOrganizationPayload> payloads = new ArrayList<>();
        ArrayList<String> orgNames = new ArrayList<>();
        ArrayList<String> orgCodes = new ArrayList<>();
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (int i = dataStartRow; i<=sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            //序号判断(防止表格填错)
            if (ObjectUtils.isEmpty(ExcelUtil.getCellFormatValue(row.getCell(0)))) {
                throw TwException.error("","表结构错误");
            }
            PrdOrgOrganizationPayload payload = new PrdOrgOrganizationPayload();
            //维度
            String dimensionId = ExcelUtil.getCellFormatValue(row.getCell(7));
            if (StringUtils.hasText(dimensionId)) {
                default_dimension_id = Long.parseLong(dimensionId.replace(".0",""));
            }
            payload.setDimensionId(default_dimension_id);
            //组织名称
             String orgName = ExcelUtil.getCellFormatValue(row.getCell(1));
            if (StringUtils.hasText(orgName)) {
                if (orgNames.contains(orgName)) {
                    throw TwException.error("", "组织名称不可重复");
                } else if (!ObjectUtils.isEmpty(dao.queryByNameAndDimensionId(orgName,default_dimension_id))) {
                    log.error("同维度下，组织名称已存在");
                    continue;
                } else {
                    orgNames.add(orgName);
                    payload.setOrgName(orgName);
                }
            } else {
                throw TwException.error("", "组织名称不可为空");
            }
            //组织编号
            String orgCode = ExcelUtil.getCellFormatValue(row.getCell(2));
            //组织编号不为空
            if (StringUtils.hasText(orgCode)) {
                //如果重复
                if (orgCodes.contains(orgCode)) {
                    throw TwException.error("", "组织编号不可重复");
                } else if (orgCode.contains(String.valueOf(".0"))){   //如果有 .0则去掉
                    orgCode = orgCode.replace(".0","");
                }
                //判断和数据库是否重复
                if (!ObjectUtils.isEmpty(dao.queryByOrgCodeAndDimensionId(orgCode, default_dimension_id))) {
                    log.error("同维度下，组织编号已存在");
                    continue;
                }
                orgCodes.add(orgCode);
                payload.setOrgCode(orgCode);
            } else {
                throw TwException.error("", "组织编号不可为空");
            }
            //组织负责人
            String manageName = ExcelUtil.getCellFormatValue(row.getCell(3));
            String manageNo = ExcelUtil.getCellFormatValue(row.getCell(4));
            if (StringUtils.hasText(manageNo)) {
                PrdOrgEmployeeDO do1 = employeeDAO.queryByEmployeeNo(manageNo);
                if (!ObjectUtils.isEmpty(do1) && do1.getId() != null) {
                        payload.setManageId(do1.getId());
                } else if (StringUtils.hasText(manageName)) {
                    PrdOrgEmployeeDO do2 = employeeDAO.queryByUserName(manageName);
                    if (!ObjectUtils.isEmpty(do2) && do2.getId() != null) {
                        payload.setManageId(do2.getId());
                    }
                }
            }
            //上级组织编号
            String parentNo = ExcelUtil.getCellFormatValue(row.getCell(6));
            //如果存在上级编号
            if (StringUtils.hasText(parentNo)) {
                //如果编号中含有 .0  则去掉  然后进行业务操作
                if (parentNo.contains(String.valueOf(".0"))) {
                    parentNo = parentNo.replace(".0", "");
                }
                //根据编号获取id
                PrdOrgOrganizationDO entity = dao.queryByOrgCode(parentNo);
                if (!ObjectUtils.isEmpty(entity) && entity.getId() != null) {
                    payload.setParentId(entity.getId());
                    parentIds.add(entity.getId());
                }
            }
            payloads.add(payload);
        }

        PrdOrgOrganizationRefDO prdOrgOrganizationDo = new PrdOrgOrganizationRefDO();
        ArrayList<PrdOrgOrganizationRefDO> prdOrgOrganizationRefDos = new ArrayList<>();
        for (PrdOrgOrganizationPayload payload : payloads) {
            PrdOrgOrganizationDO entity = dao.save(PrdOrgOrganizationConvert.INSTANCE.toDo(payload));
            //如果存在上级组织
            if (null != payload.getParentId() ) {
                prdOrgOrganizationDo.setParentId(payload.getParentId());
            }
            prdOrgOrganizationDo.setOrgId(entity.getId());
            prdOrgOrganizationDo.setDimensionId(entity.getDimensionId());
            prdOrgOrganizationRefDos.add(prdOrgOrganizationDo);
        }
        repo.saveAll(prdOrgOrganizationRefDos);
    }
}
