package com.elitesland.tw.tw5.server.prd.qixin.service;

/**
 * 启信宝 服务
 *
 * @author duwh
 * @date 2022/11/22
 */
public interface QiXinService {

    /**
     * 1.31 模糊搜索
     *
     * @param matchType 匹配类型（可选），keyword 需要匹配的 字段，可以输入以下一个或者几个类型， 多个类型使用|分隔： partner：股东 oper：法人 4 member：高管 contact：联系方式 scope：经营范围 name：公司名称 patent：专利 copyright：著作权作品名称 software：软件著作权名称 trademark：商标 domain：网址 product：产品
     * @param region    地区编码（可选），输入参数为空返回全 部区域匹配记录。可传入 省/直辖市，城市，区县的国家区划码。 只支持传入一个区划码。 省/直辖市：传入国家区划码前两位数字， 如搜索“江苏省”则传入 32，各省/直辖 市编码可参考本文档附录 城市：传入国家区划码前四位数字，如搜 索“苏州市”，则传入 3205 区县：传入国家区划码六位数字，如搜索 “苏州市吴中区”，则传入 320506 可以通过下面网页查询国家区划编码 http://www.mca.gov.cn/article/sj/tj bz/a/2017/2018
     * @param keyword   关键字（必填） 企业全名/注册号/统一社会信用代码
     * @param skip      跳过(可选) 跳过条目数（默认为0，单页返回10条数据）
     * @return {@link String}
     */
    String search(String matchType, String region, String keyword, String skip);

    /**
     * 1.2 高级搜索
     *
     * @param keyword       企业全名/注册号/统一社会信用代码
     * @param skip          跳过条目数（默认为0，单页返回20条数据）
     * @param method        搜索范围，多个使用逗号分隔，具体值参 考附录
     * @param org_type      组织类型，多个使用逗号分隔，具体值参 考附录
     * @param area_code     地区码
     * @param industry_code 行业码
     * @param econ_type     企业类型，多个使用逗号分隔，具体值参 考附录
     * @param capi_from     注册资本起
     * @param capi_to       注册资本止
     * @param date_from     成立日期起
     * @param date_to       成立日期止
     * @param status        企业状态，多个使用逗号分隔，具体值参 考附录
     * @param canbao_from   参保人数起
     * @param canbao_to     参保人数止
     * @return {@link String}
     */
    String advanceSearchNew(String keyword, String skip, String method, String org_type, String area_code, String industry_code,
                            String econ_type, String capi_from, String capi_to, String date_from, String date_to,
                            String status, String canbao_from, String canbao_to);

    /**
     * 获取企业联系方式 1.51 企业联系方式
     *
     * @param keyword 关键字 企业全名/注册号/统一社会信用代码
     * @return {@link String}
     */
    String getContactInfo(String keyword);

    /**
     * 10.1 新闻列表
     * 企业新闻列表，包括新闻来源、情感属性、舆情标签、负面指数等
     * 申请接口
     * 单价：0.1元/次
     *
     * @param name              必填 企业全名/注册号/统一社会信用代码
     * @param skip              跳过条目数（默认为 0）
     * @param tag_list          舆情分类，参考数据字典tag_list字段，示例：["131","132"]
     * @param sentiment         情感属性，参考数据字典sentiment字段，示例：["neg","pos"]
     * @param company_sentiment 企业的情感属性，参考数据字典sentiment字段，示例：["neg","pos"]
     * @param class_types       新闻类别，全部可不传，参考数据字典class_types字段，示例：["news"]
     * @param new_tag_list      事件分类，参考数据字典new_tag_list字段，示例：["101","1024"]
     * @param company_new_tag   企业的事件分类，参考数据字典new_tag_list字段，示例：["0102004","0102005"]
     * @param create_time_range 舆情发布时间范围，示例：["2019-01-01","2019-08-14"]
     * @return {@link String}
     */
    String getNewsListByName(String name, String skip, String tag_list, String sentiment,
                             String company_sentiment, String class_types, String new_tag_list,
                             String company_new_tag, String create_time_range);

    /**
     * 1.41 工商照面
     * 企业工商照面及相关信息，包括统一社会信用代码、注册资本、经营范围、企业法定代表人等
     *
     * @param keyword 企业全名/注册号/统一社会信用代码
     * @return
     */
    String getBasicInfo(String keyword);

    /**
     * 1.17 企业LOGO
     *
     * @param name 名字
     * @return {@link String}
     */
    String getEntLogoByName(String name);

    /**
     * 1.16 企业简介
     *
     * @param name 名字
     * @return {@link String}
     */
    String getEntBriefByName(String name);

    /**
     * 1.53 企业年报网址
     * 企业年报网址信息，包括网站名称、网址、网址类型、网址来源、审核时间等
     * <p>
     * 单价：0.1元/次
     *
     * @param keyword 企业全名/注册号/统一社会信用代码
     * @param skip    跳过条目数（默认为0，单页返回20条数据）
     * @return {@link String}
     */
    String getGetWebsites(String keyword, String skip);

    /**
     * 1.43 工商股东
     * 企业工商股东信息(不包含企业自行公示和年报股东)
     *
     * 单价：0.1元/次
     *
     * @param keyword 企业全名/注册号/统一社会信用代码
     * @param skip    跳过条目数（默认为0，单页返回20条数据）
     * @return {@link String}
     */
    String getPartners(String keyword, String skip);

    /**
     * 1.45 主要人员
     * 企业工商主要人员信息，包括主要人员姓名及职位
     * <p>
     * 单价：0.1元/次
     *
     * @param keyword 企业全名/注册号/统一社会信用代码
     * @param skip    跳过条目数（默认为0，单页返回20条数据）
     * @return {@link String}
     */
    String getGetEmployees(String keyword, String skip);

    /**
     * 发起请求
     *
     * @param path 路径
     * @return {@link String}
     */
    String getMessage(String path);


}
