/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgCompanyNoticePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgCompanyNoticeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyNoticeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyNoticeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSettingEnum;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgCompanyNoticeConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgCompanyNoticeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyNoticeDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgCompanyNoticeRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdOrgCompanyNoticeServiceImpl
implements PrdOrgCompanyNoticeService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgCompanyNoticeServiceImpl.class);
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgCompanyNoticeDAO dao;
    private final PrdMessageConfigDAO messageConfigDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgCompanyNoticeRepo repo;

    void checkTriggerTime(PrdOrgCompanyNoticePayload payload) {
        if (StringUtils.hasText((String)payload.getNoticeType()) && "ACTIVITY".equals(payload.getNoticeType())) {
            if (StringUtils.hasText((String)payload.getTriggerTimeExpression())) {
                throw TwException.error("", "\u6d3b\u52a8\u516c\u544a\u4e0d\u652f\u6301\u5b9a\u65f6\u53d1\u5e03\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!StringUtils.hasText((String)payload.getSourceId())) {
                throw TwException.error("", "\u8d44\u6e90id\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else if (StringUtils.hasText((String)payload.getTriggerTimeExpression()) && !CronExpression.isValidExpression((String)payload.getTriggerTimeExpression())) {
            throw TwException.error("", "\u65e0\u6548\u7684\u65f6\u95f4\u8868\u8fbe\u5f0f\u683c\u5f0f");
        }
    }

    @Transactional
    public PrdOrgCompanyNoticeVO insert(PrdOrgCompanyNoticePayload payload) {
        this.checkTriggerTime(payload);
        payload.setReadAmount(Long.valueOf(0L));
        payload.setPublishFlag(Integer.valueOf(0));
        payload.setChangeTime(LocalDateTime.now());
        PrdOrgCompanyNoticeDO ado = PrdOrgCompanyNoticeConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        return PrdOrgCompanyNoticeConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public PrdOrgCompanyNoticeVO update(PrdOrgCompanyNoticePayload payload) {
        this.checkTriggerTime(payload);
        PrdOrgCompanyNoticeDO ado = PrdOrgCompanyNoticeConvert.INSTANCE.toDo(payload);
        ado.setChangeTime(LocalDateTime.now());
        ado = this.dao.save(ado);
        return PrdOrgCompanyNoticeConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
    }

    public PrdOrgCompanyNoticeVO queryByKey(Long key) {
        PrdOrgCompanyNoticeVO prdOrgCompanyNoticeVO = this.dao.queryByKey(key);
        prdOrgCompanyNoticeVO.setReadAmount(Long.valueOf(prdOrgCompanyNoticeVO.getReadAmount() + 1L));
        PrdOrgCompanyNoticeDO prdOrgCompanyNoticeDO = PrdOrgCompanyNoticeConvert.INSTANCE.toDo(prdOrgCompanyNoticeVO);
        this.dao.save(prdOrgCompanyNoticeDO);
        this.transaction(Collections.singletonList(prdOrgCompanyNoticeVO));
        return prdOrgCompanyNoticeVO;
    }

    public PagingVO<PrdOrgCompanyNoticeVO> paging(PrdOrgCompanyNoticeQuery query) {
        PagingVO<PrdOrgCompanyNoticeVO> paging = this.dao.queryPaging(query);
        List records = paging.getRecords();
        this.transaction(records);
        return paging;
    }

    @Transactional
    public Boolean publish(List<Long> keys) {
        List<PrdOrgCompanyNoticeDO> noticeDOS = this.dao.queryByKeys(keys, 0);
        if (ObjectUtils.isEmpty(noticeDOS)) {
            throw TwException.error("", "\u4ec5\u652f\u6301\u672a\u53d1\u5e03\u516c\u544a");
        }
        this.dao.updatePublishFlagByIds(keys, 1);
        ArrayList activityId = new ArrayList();
        ArrayList timeNoticeDOs = new ArrayList();
        noticeDOS.forEach(noticeDO -> {
            if (StringUtils.hasText((String)noticeDO.getTriggerTimeExpression()) || StringUtils.hasText((String)noticeDO.getNoticeType()) && "ACTIVITY".equals(noticeDO.getNoticeType())) {
                if (StringUtils.hasText((String)noticeDO.getNoticeType()) && "ACTIVITY".equals(noticeDO.getNoticeType())) {
                    activityId.add(Long.valueOf(noticeDO.getSourceId()));
                } else {
                    timeNoticeDOs.add(noticeDO);
                }
            }
        });
        if (timeNoticeDOs.size() > 0) {
            timeNoticeDOs.forEach(noticeDO -> this.createXXLJob((PrdOrgCompanyNoticeDO)noticeDO));
        }
        return true;
    }

    void createXXLJob(PrdOrgCompanyNoticeDO ado) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAuthor(ado.getCreator());
        xxlJobInfo.setJobGroup(Integer.valueOf(this.cacheUtil.getSystemSetting(FunctionSettingEnum.JOB_GROUP.getCode()).getSettingValue()));
        xxlJobInfo.setJobCron(ado.getTriggerTimeExpression());
        xxlJobInfo.setJobDesc(ado.getNoticeTitle());
        xxlJobInfo.setExecutorHandler("xxl-job-company-notice");
        xxlJobInfo.setExecutorParam("" + ado.getId());
        xxlJobInfo.setTriggerStatus(1);
        this.messageConfigDAO.saveXxlJob(xxlJobInfo);
    }

    @Transactional
    public Boolean revoke(List<Long> keys) {
        List<PrdOrgCompanyNoticeDO> noticeDOS = this.dao.queryByKeys(keys, 1);
        if (ObjectUtils.isEmpty(noticeDOS)) {
            throw TwException.error("", "\u4ec5\u652f\u6301\u5df2\u53d1\u5e03\u516c\u544a\u64a4\u56de");
        }
        this.dao.updatePublishFlagByIds(keys, 0);
        ArrayList<String> timeNoticeIds = new ArrayList<String>();
        noticeDOS.forEach(noticeDO -> {
            if (!(!StringUtils.hasText((String)noticeDO.getTriggerTimeExpression()) || StringUtils.hasText((String)noticeDO.getNoticeType()) && "ACTIVITY".equals(noticeDO.getNoticeType()))) {
                timeNoticeIds.add("" + noticeDO.getId());
            }
        });
        if (timeNoticeIds.size() > 0) {
            this.messageConfigDAO.deleteXxlJobById(timeNoticeIds);
        }
        return true;
    }

    public List<PrdOrgCompanyNoticeVO> queryList(PrdOrgCompanyNoticeQuery query) {
        List<PrdOrgCompanyNoticeVO> vos = this.dao.queryListDynamic(query);
        this.transaction(vos);
        return vos;
    }

    @Transactional
    public void companyNoticeJobHandler(String param) {
        System.out.println("companyNoticeJobHandler param::" + param);
        if (StringUtil.isInteger(param)) {
            this.repo.updataCompanyNoticeTime(Long.valueOf(param), LocalDateTime.now());
        }
    }

    private void transaction(List<PrdOrgCompanyNoticeVO> list) {
        ArrayList<Long> userIdList = new ArrayList<Long>();
        list.stream().forEach(e -> {
            if (!ObjectUtils.isEmpty((Object)e.getNoticeAuthorUserId())) {
                userIdList.add(e.getNoticeAuthorUserId());
            }
        });
        List<PrdOrgEmployeeVO> employeeVOS = this.employeeDAO.queryMobileList(userIdList);
        Map sysUserVOMap = employeeVOS.stream().collect(Collectors.toMap(PrdOrgEmployeeVO::getUserId, Function.identity()));
        for (PrdOrgCompanyNoticeVO vo : list) {
            PrdOrgEmployeeVO sysUser;
            if (ObjectUtils.isEmpty((Object)vo.getNoticeAuthorUserId()) || ObjectUtils.isEmpty((Object)(sysUser = (PrdOrgEmployeeVO)sysUserVOMap.get(vo.getNoticeAuthorUserId())))) continue;
            vo.setNoticeAuthor(sysUser.getEmployeeName());
        }
    }

    public PrdOrgCompanyNoticeServiceImpl(PrdOrgEmployeeDAO employeeDAO, PrdOrgCompanyNoticeDAO dao, PrdMessageConfigDAO messageConfigDAO, CacheUtil cacheUtil, PrdOrgCompanyNoticeRepo repo) {
        this.employeeDAO = employeeDAO;
        this.dao = dao;
        this.messageConfigDAO = messageConfigDAO;
        this.cacheUtil = cacheUtil;
        this.repo = repo;
    }
}

