/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.service;

import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdScheduleAttendeesPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdScheduleRepeatPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxScheduleAttendeesPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxScheduleRepeatPayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdScheduleQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleAttendeesVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleRepeatVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdScheduleAttendeesConvert;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdScheduleConvert;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdScheduleRepeatConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleAttendeesDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleRepeatDAO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleAttendeesDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleRepeatDO;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdScheduleServiceImpl
implements PrdScheduleService {
    private static final Logger log = LoggerFactory.getLogger(PrdScheduleServiceImpl.class);
    private final PrdScheduleDAO dao;
    private final PrdScheduleRepeatDAO repeatDAO;
    private final PrdScheduleAttendeesDAO attendeesDAO;
    private final QyWxCommunicationService wxService;
    private final PrdCalendarService calendarService;
    private final PrdCalendarDAO calendarDAO;

    @Transactional
    public PrdScheduleVO insertOrUpdate(PrdSchedulePayload payload) {
        if (!payload.getEndTime().isAfter(payload.getStartTime())) {
            throw TwException.error("", "\u65e5\u7a0b\u7684\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u65e5\u7a0b\u7684\u5f00\u59cb\u65f6\u95f4\uff01");
        }
        boolean isNew = payload.getId() == null;
        PrdScheduleDO ado = PrdScheduleConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        Long scheduleId = ado.getId();
        payload.setId(ado.getId());
        payload.setCreateUserId(ado.getCreateUserId());
        List attendees = payload.getAttendees();
        List<PrdScheduleAttendeesVO> attendeesVOs = this.attendeesDAO.queryByScheduleId(scheduleId);
        if (attendees != null && !attendees.isEmpty() && !payload.getSkipAttendees().booleanValue()) {
            boolean b;
            for (PrdScheduleAttendeesPayload attendee : attendees) {
                b = attendeesVOs.stream().anyMatch(m -> m.getUserId().equals(attendee.getUserId()));
                if (b) continue;
                attendee.setSecheduleId(scheduleId);
                PrdScheduleAttendeesDO prdScheduleAttendeesDO = PrdScheduleAttendeesConvert.INSTANCE.toDo(attendee);
                this.attendeesDAO.save(prdScheduleAttendeesDO);
            }
            for (PrdScheduleAttendeesVO attendeesVO : attendeesVOs) {
                b = attendees.stream().anyMatch(m -> m.getUserId().equals(attendeesVO.getUserId()));
                ArrayList<Long> ids = new ArrayList<Long>();
                if (!b) {
                    ids.add(attendeesVO.getId());
                }
                this.attendeesDAO.deleteSoft(ids);
            }
        } else {
            List<Long> collect = attendeesVOs.stream().map(item -> item.getId()).collect(Collectors.toList());
            this.attendeesDAO.deleteSoft(collect);
        }
        PrdScheduleRepeatPayload repeat = payload.getRepeat();
        if (repeat != null && payload.getIsRepeat() == 1 && !payload.getSkipRepeat().booleanValue()) {
            repeat.setSecheduleId(scheduleId);
            PrdScheduleRepeatDO prdScheduleRepeatDO = PrdScheduleRepeatConvert.INSTANCE.toDo(repeat);
            if (repeat.getRepeatDayOfMonth() != null || repeat.getRepeatDayOfMonth() != "") {
                List<Integer> elements = this.transCapitalToNumber(repeat.getRepeatDayOfMonth());
                String join = StringUtils.join(elements, (String)",");
                repeat.setRepeatDayOfMonth(join);
            }
            this.repeatDAO.save(prdScheduleRepeatDO);
        }
        if (payload.getFromQyWx() == null || !payload.getFromQyWx().booleanValue()) {
            if (isNew) {
                String qywxScheduleId = this.wxService.saveSchedule(this.transferToQyWxPayload(payload));
                ado.setQyWxScheduleId(qywxScheduleId);
                this.dao.save(ado);
            } else {
                PrdScheduleVO prdScheduleVO = this.dao.queryByKey(payload.getId());
                payload.setCreateUserId(prdScheduleVO.getCreateUserId());
                payload.setQyWxScheduleId(prdScheduleVO.getQyWxScheduleId());
                this.wxService.updateSchedule(this.transferToQyWxPayload(payload));
            }
        }
        return PrdScheduleConvert.INSTANCE.toVo(ado);
    }

    public QyWxSchedulePayload transferToQyWxPayload(PrdSchedulePayload schedulePayload) {
        PrdScheduleRepeatPayload repeat;
        QyWxSchedulePayload payload = new QyWxSchedulePayload();
        Long calId = schedulePayload.getCalId();
        payload.setCal_id(this.calendarDAO.queryByKey(calId).getQyWxCalId());
        payload.setSchedule_id(schedulePayload.getQyWxScheduleId());
        payload.setSummary(schedulePayload.getTitle());
        payload.setDescription(schedulePayload.getDescription());
        payload.setLocation(schedulePayload.getLocation());
        payload.setStart_time(Long.valueOf(schedulePayload.getStartTime().atZone(ZoneOffset.ofHours(8)).toEpochSecond()));
        payload.setEnd_time(Long.valueOf(schedulePayload.getEndTime().atZone(ZoneOffset.ofHours(8)).toEpochSecond()));
        payload.setSkip_attendees(schedulePayload.getSkipAttendees());
        Long createUserId = schedulePayload.getCreateUserId();
        String weComId = this.calendarService.getWeComId(createUserId);
        payload.setOrganizer(weComId);
        ArrayList<QyWxScheduleAttendeesPayload> qyWxScheduleAttendees = new ArrayList<QyWxScheduleAttendeesPayload>();
        List attendees = schedulePayload.getAttendees();
        if (attendees != null && !attendees.isEmpty()) {
            for (PrdScheduleAttendeesPayload attendee : attendees) {
                QyWxScheduleAttendeesPayload qywxAttendee = new QyWxScheduleAttendeesPayload();
                Long userId = attendee.getUserId();
                qywxAttendee.setUserid(this.calendarService.getWeComId(userId));
                qyWxScheduleAttendees.add(qywxAttendee);
            }
        }
        if ((repeat = schedulePayload.getRepeat()) != null) {
            QyWxScheduleRepeatPayload qyWxScheduleRepeat = new QyWxScheduleRepeatPayload();
            qyWxScheduleRepeat.setIs_remind(schedulePayload.getIsRemind());
            qyWxScheduleRepeat.setRemind_before_event_secs(schedulePayload.getRemindBeforeEventSecs());
            qyWxScheduleRepeat.setIs_repeat(schedulePayload.getIsRepeat());
            qyWxScheduleRepeat.setIs_custom_repeat(repeat.getIsCustomRepeat());
            qyWxScheduleRepeat.setRepeat_type(repeat.getRepeatType());
            qyWxScheduleRepeat.setRepeat_until(repeat.getRepeatUntil() == null ? null : Long.valueOf(repeat.getRepeatUntil().atStartOfDay(ZoneOffset.ofHours(8)).toEpochSecond()));
            qyWxScheduleRepeat.setRepeat_interval(repeat.getRepeatInterval());
            qyWxScheduleRepeat.setRepeat_day_of_week(repeat.getRepeatDayOfWeek() == null || repeat.getRepeatDayOfWeek() == "" ? null : Arrays.stream(repeat.getRepeatDayOfWeek().split(",")).map(item -> Integer.parseInt(item) + 1).collect(Collectors.toList()));
            qyWxScheduleRepeat.setRepeat_day_of_month(this.transCapitalToNumber(repeat.getRepeatDayOfMonth()));
            if (repeat.getExdate() != null) {
                String[] split = repeat.getExdate().split(",");
                List excludeList = Arrays.stream(split).map(item -> {
                    HashMap<String, Long> timeMap = new HashMap<String, Long>();
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    long time = LocalDateTime.parse(item, dateTimeFormatter).atZone(ZoneOffset.ofHours(8)).toEpochSecond();
                    timeMap.put("start_time", time);
                    return timeMap;
                }).collect(Collectors.toList());
                qyWxScheduleRepeat.setExclude_time_list(excludeList);
            }
            qyWxScheduleRepeat.setTimezone(Integer.valueOf(8));
            payload.setReminders(qyWxScheduleRepeat);
        }
        payload.setAttendees(qyWxScheduleAttendees);
        return payload;
    }

    public PrdSchedulePayload transferToPrdPayload(QyWxSchedulePayload schedulePayload) {
        PrdSchedulePayload payload = new PrdSchedulePayload();
        PrdCalendarVO prdCalendarVO = this.calendarDAO.queryByQyWxCalId(schedulePayload.getCal_id());
        payload.setCalId(prdCalendarVO.getId());
        payload.setQyWxScheduleId(schedulePayload.getSchedule_id());
        payload.setTitle(schedulePayload.getSummary());
        payload.setDescription(schedulePayload.getDescription());
        payload.setLocation(schedulePayload.getLocation());
        payload.setStartTime(Instant.ofEpochSecond(schedulePayload.getStart_time()).atZone(ZoneOffset.ofHours(8)).toLocalDateTime());
        payload.setEndTime(Instant.ofEpochSecond(schedulePayload.getEnd_time()).atZone(ZoneOffset.ofHours(8)).toLocalDateTime());
        payload.setSkipAttendees(schedulePayload.getSkip_attendees());
        String organizer = schedulePayload.getOrganizer();
        Long createUserId = this.calendarService.getUserIdByWeComId(organizer);
        payload.setCreateUserId(createUserId);
        ArrayList<PrdScheduleAttendeesPayload> prdScheduleAttendees = new ArrayList<PrdScheduleAttendeesPayload>();
        List attendees = schedulePayload.getAttendees();
        if (attendees != null && !attendees.isEmpty()) {
            for (QyWxScheduleAttendeesPayload attendee : attendees) {
                PrdScheduleAttendeesPayload prdAttendee = new PrdScheduleAttendeesPayload();
                Long userId = this.calendarService.getUserIdByWeComId(attendee.getUserid());
                prdAttendee.setUserId(userId);
                prdAttendee.setUserId(Long.valueOf(1L));
                prdScheduleAttendees.add(prdAttendee);
            }
        }
        PrdScheduleRepeatPayload prdScheduleRepeat = new PrdScheduleRepeatPayload();
        QyWxScheduleRepeatPayload reminders = schedulePayload.getReminders();
        payload.setIsRemind(reminders.getIs_remind());
        payload.setIsRepeat(reminders.getIs_repeat());
        payload.setRemindBeforeEventSecs(reminders.getRemind_before_event_secs());
        prdScheduleRepeat.setIsCustomRepeat(reminders.getIs_custom_repeat());
        prdScheduleRepeat.setRepeatType(reminders.getRepeat_type());
        LocalDate untilDate = LocalDate.now();
        if (reminders.getRepeat_until() != null || reminders.getRepeat_until() == 0L) {
            long time = schedulePayload.getStart_time() + 315360000L;
            untilDate = Instant.ofEpochSecond(time).atZone(ZoneOffset.ofHours(8)).toLocalDate();
        } else {
            untilDate = Instant.ofEpochSecond(reminders.getRepeat_until()).atZone(ZoneOffset.ofHours(8)).toLocalDate();
        }
        prdScheduleRepeat.setRepeatUntil(untilDate);
        prdScheduleRepeat.setRepeatInterval(reminders.getRepeat_interval());
        prdScheduleRepeat.setRepeatDayOfWeek(reminders.getRepeat_day_of_week() == null ? null : StringUtils.join((Object[])new Object[]{reminders.getRepeat_day_of_week().stream().map(item -> item - 1), ","}));
        prdScheduleRepeat.setRepeatDayOfMonth(this.transNumberToCapital(reminders.getRepeat_day_of_month()));
        if (reminders.getExclude_time_list() != null && !reminders.getExclude_time_list().isEmpty()) {
            String exdate = reminders.getExclude_time_list().stream().map(item -> {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long time = Long.valueOf((Long)item.get("start_time")) * 1000L;
                String format = sdf.format(new Date(time));
                return format;
            }).collect(Collectors.joining(","));
            prdScheduleRepeat.setExdate(exdate);
        }
        payload.setAttendees(prdScheduleAttendees);
        payload.setRepeat(prdScheduleRepeat);
        return payload;
    }

    private String transNumberToCapital(List<Integer> numbers) {
        if (numbers == null) {
            return null;
        }
        numbers.stream().map(item -> {
            int numberInt = item;
            if (numberInt > 9) {
                char capitalChar = (char)(numberInt + 55);
                return Character.toString(capitalChar);
            }
            return item;
        });
        return StringUtils.join(numbers, (String)",");
    }

    private List<Integer> transCapitalToNumber(String capitals) {
        String[] capital;
        if (capitals == null || capitals.length() < 1) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String item : capital = capitals.split(",")) {
            char capitalChar = item.charAt(0);
            if (capitalChar < ':') {
                result.add(Integer.parseInt(item));
                continue;
            }
            result.add(Integer.parseInt(String.valueOf(capitalChar - 55)));
        }
        return result;
    }

    public List<PrdScheduleVO> queryList(PrdScheduleQuery query) {
        List<PrdScheduleVO> scheduleVOS = this.dao.queryListDynamic(query);
        for (PrdScheduleVO scheduleVO : scheduleVOS) {
            if (scheduleVO.getRepeatDayOfMonth() == null && scheduleVO.getRepeatDayOfMonth() == "") continue;
            List<PrdScheduleAttendeesVO> attendeesVOs = this.attendeesDAO.queryByScheduleId(scheduleVO.getId());
            scheduleVO.setAttendeesVOS(attendeesVOs);
            List<Integer> elements = this.transCapitalToNumber(scheduleVO.getRepeatDayOfMonth());
            String join = StringUtils.join(elements, (String)",");
            scheduleVO.setRepeatDayOfMonthNumber(join);
        }
        return scheduleVOS;
    }

    public PrdScheduleVO queryDetail(Long id) {
        PrdScheduleVO prdScheduleVO = this.dao.queryByKey(id);
        if (prdScheduleVO != null) {
            List<PrdScheduleAttendeesVO> attendeesVOs = this.attendeesDAO.queryByScheduleId(prdScheduleVO.getId());
            PrdScheduleRepeatVO repeatVo = this.repeatDAO.queryByScheduleId(prdScheduleVO.getId());
            prdScheduleVO.setRepeatVO(repeatVo);
            prdScheduleVO.setAttendeesVOS(attendeesVOs);
            List<Integer> elements = this.transCapitalToNumber(prdScheduleVO.getRepeatDayOfMonth());
            String join = StringUtils.join(elements, (String)",");
            prdScheduleVO.setRepeatDayOfMonthNumber(join);
        }
        return prdScheduleVO;
    }

    @Transactional
    public void deleteCurrent(Long id, String date) {
        LocalDateTime startTime = this.dao.queryByKey(id).getStartTime();
        int hour = startTime.getHour();
        int minute = startTime.getMinute();
        int second = startTime.getSecond();
        String exTime = date + " " + StringUtils.leftPad((String)String.valueOf(hour), (int)2, (String)"0") + ":" + StringUtils.leftPad((String)String.valueOf(minute), (int)2, (String)"0") + ":" + StringUtils.leftPad((String)String.valueOf(second), (int)2, (String)"0");
        PrdScheduleRepeatPayload payload = new PrdScheduleRepeatPayload();
        PrdScheduleRepeatVO repeatVO = this.repeatDAO.queryByScheduleId(id);
        String exdate = repeatVO.getExdate();
        payload.setExdate(exdate == null || exdate == "" ? exTime : exdate + "," + exTime);
        payload.setId(repeatVO.getId());
        this.repeatDAO.updateByKeyDynamic(payload);
        PrdScheduleVO prdScheduleVO = this.queryDetail(id);
        PrdSchedulePayload prdSchedulePayload = this.transVoToPayLoad(prdScheduleVO);
        if (prdScheduleVO.getQyWxScheduleId() != null) {
            QyWxSchedulePayload qyWxSchedulePayload = this.transferToQyWxPayload(prdSchedulePayload);
            this.wxService.updateSchedule(qyWxSchedulePayload);
        }
    }

    @Transactional
    public void deleteAfter(Long id, String date) {
        LocalDate repeatUntil = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        PrdScheduleRepeatPayload payload = new PrdScheduleRepeatPayload();
        PrdScheduleRepeatVO repeatVO = this.repeatDAO.queryByScheduleId(id);
        payload.setId(repeatVO.getId());
        payload.setRepeatUntil(repeatUntil);
        this.repeatDAO.updateByKeyDynamic(payload);
        PrdScheduleVO prdScheduleVO = this.queryDetail(id);
        PrdSchedulePayload prdSchedulePayload = this.transVoToPayLoad(prdScheduleVO);
        if (prdScheduleVO.getQyWxScheduleId() != null) {
            QyWxSchedulePayload qyWxSchedulePayload = this.transferToQyWxPayload(prdSchedulePayload);
            this.wxService.updateSchedule(qyWxSchedulePayload);
        }
    }

    private PrdSchedulePayload transVoToPayLoad(PrdScheduleVO prdScheduleVO) {
        PrdScheduleRepeatVO repeatVO = prdScheduleVO.getRepeatVO();
        List attendeesVOS = prdScheduleVO.getAttendeesVOS();
        PrdSchedulePayload prdSchedulePayload = PrdScheduleConvert.INSTANCE.toPayload(prdScheduleVO);
        if (repeatVO != null) {
            PrdScheduleRepeatPayload repeatPayload = PrdScheduleRepeatConvert.INSTANCE.toPayload(repeatVO);
            prdSchedulePayload.setRepeat(repeatPayload);
        }
        if (attendeesVOS != null && !attendeesVOS.isEmpty()) {
            ArrayList<PrdScheduleAttendeesPayload> attendeesPayloads = new ArrayList<PrdScheduleAttendeesPayload>();
            for (PrdScheduleAttendeesVO attendeesVO : attendeesVOS) {
                PrdScheduleAttendeesPayload attendeesPayload = PrdScheduleAttendeesConvert.INSTANCE.toPayload(attendeesVO);
                attendeesPayloads.add(attendeesPayload);
            }
            prdSchedulePayload.setAttendees(attendeesPayloads);
        }
        return prdSchedulePayload;
    }

    @Transactional
    public void updateCurrent(PrdSchedulePayload payload) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String date = dateTimeFormatter.format(payload.getStartTime());
        this.deleteCurrent(payload.getId(), date);
        payload.setRepeat(new PrdScheduleRepeatPayload());
        payload.setIsRepeat(Integer.valueOf(0));
        payload.setId(null);
        this.insertOrUpdate(payload);
    }

    @Transactional
    public void updateAfter(PrdSchedulePayload payload) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String date = dateTimeFormatter.format(payload.getStartTime());
        this.deleteAfter(payload.getId(), date);
        payload.setId(null);
        payload.setQyWxScheduleId(null);
        PrdScheduleRepeatPayload repeat = payload.getRepeat();
        repeat.setId(null);
        this.insertOrUpdate(payload);
    }

    @Transactional
    public void deleteSoft(List<Long> asList) {
        for (Long scheduleId : asList) {
            PrdScheduleVO prdScheduleVO = this.dao.queryByKey(scheduleId);
            String qyWxScheduleId = prdScheduleVO.getQyWxScheduleId();
            if (qyWxScheduleId == null) continue;
            this.wxService.deleteSchedule(qyWxScheduleId);
        }
        this.dao.deleteSoft(asList);
    }

    public PrdScheduleServiceImpl(PrdScheduleDAO dao, PrdScheduleRepeatDAO repeatDAO, PrdScheduleAttendeesDAO attendeesDAO, QyWxCommunicationService wxService, PrdCalendarService calendarService, PrdCalendarDAO calendarDAO) {
        this.dao = dao;
        this.repeatDAO = repeatDAO;
        this.attendeesDAO = attendeesDAO;
        this.wxService = wxService;
        this.calendarService = calendarService;
        this.calendarDAO = calendarDAO;
    }
}

