/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.common.TwCommonVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdMessageConfigQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.common.util.JavaMailPayload;
import com.elitesland.tw.tw5.server.common.util.JavaMailUtil;
import com.elitesland.tw.tw5.server.common.util.SpelUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSettingEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.MessageNoticeScopeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.MessageNoticeWayEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.MessageReleaseSourceEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserMessageDO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class PrdMessageConfigServiceImpl
extends BaseServiceImpl
implements PrdMessageConfigService {
    private static final Logger log = LoggerFactory.getLogger(PrdMessageConfigServiceImpl.class);
    private final PrdMessageConfigDAO dao;
    private final PrdSystemRoleDAO daoSysRole;
    private final CacheUtil cacheUtil;
    private final JavaMailUtil mailUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService organizationService;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final String timing = "timing";
    @Value(value="${tw5.mail.message_email}")
    private String message_email;

    boolean checkTriggerTime(PrdMessageConfigPayload payload) {
        boolean isTime = false;
        if ("timing".equals(payload.getTriggerWay())) {
            if (payload.getMessageType() == 1) {
                if (StringUtils.hasText((String)payload.getTriggerTimeExpression())) {
                    if (!CronExpression.isValidExpression((String)payload.getTriggerTimeExpression())) {
                        throw TwException.error("", "\u65e0\u6548\u7684\u65f6\u95f4\u8868\u8fbe\u5f0f\u683c\u5f0f");
                    }
                    isTime = true;
                }
            } else if (payload.getTriggerTime() != null) {
                if (payload.getTriggerTime().isBefore(LocalDateTime.now())) {
                    throw TwException.error("", "\u53d1\u5e03\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                }
                payload.setTriggerTimeExpression(payload.getTriggerTime().format(DateTimeFormatter.ofPattern("ss mm HH dd MM ? yyyy")));
                isTime = true;
            }
        }
        return isTime;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public PrdMessageConfigVO insert(PrdMessageConfigPayload payload) {
        boolean isTime;
        if (payload.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
            payload.setMessageContent(GlobalUtil.stringHtmlFilter(payload.getMessageContent()));
        }
        if (isTime = this.checkTriggerTime(payload)) {
            payload.setReleaseStatus(Integer.valueOf(0));
        } else {
            payload.setTriggerTime(LocalDateTime.now());
            payload.setReleaseStatus(Integer.valueOf(3));
        }
        String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
        payload.setMessageCode(code);
        PrdMessageConfigDO ado = PrdMessageConfigConvert.INSTANCE.toDo(payload);
        this.getCreateSource(ado);
        ado = this.dao.save(ado);
        PrdMessageConfigVO configVO = PrdMessageConfigConvert.INSTANCE.toVo(ado);
        if (isTime) {
            this.createXXLJob(ado);
        } else {
            this.releaseMessage(Arrays.asList(configVO));
        }
        return PrdMessageConfigConvert.INSTANCE.toVo(ado);
    }

    void createXXLJob(PrdMessageConfigDO ado) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAuthor(ado.getCreator());
        xxlJobInfo.setJobGroup(Integer.valueOf(this.cacheUtil.getSystemSetting(FunctionSettingEnum.JOB_GROUP.getCode()).getSettingValue()));
        xxlJobInfo.setJobCron(ado.getTriggerTimeExpression());
        xxlJobInfo.setJobDesc(ado.getMessageTitle());
        xxlJobInfo.setExecutorHandler("xxl-job-executor-message");
        xxlJobInfo.setExecutorParam("" + ado.getId());
        xxlJobInfo.setTriggerStatus(ado.getIsEnable() == 0 ? 1 : 0);
        this.dao.saveXxlJob(xxlJobInfo);
    }

    @Transactional
    public PrdMessageConfigVO release(PrdMessageConfigPayload payload) {
        payload.setReleaseStatus(Integer.valueOf(3));
        PrdMessageConfigDO ado = PrdMessageConfigConvert.INSTANCE.toDo(payload);
        ado.setTriggerTime(LocalDateTime.now());
        this.getCreateSource(ado);
        ado = this.dao.save(ado);
        if (payload.getId() != null && payload.getId() > 0L) {
            ArrayList<String> messageIds = new ArrayList<String>();
            messageIds.add("" + payload.getId());
            this.dao.deleteXxlJobById(messageIds);
        }
        PrdMessageConfigVO configVO = PrdMessageConfigConvert.INSTANCE.toVo(ado);
        this.releaseMessage(Arrays.asList(configVO));
        return configVO;
    }

    @Transactional
    public Long update(PrdMessageConfigPayload payload) {
        PrdMessageConfigVO messageConfigVO = this.dao.queryByKey(payload.getId());
        if (messageConfigVO.getReleaseStatus() == 3) {
            throw TwException.error("", "\u5df2\u53d1\u9001\u6d88\u606f\u4e0d\u53ef\u7f16\u8f91");
        }
        if (payload.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) {
            payload.setMessageContent(GlobalUtil.stringHtmlFilter(payload.getMessageContent()));
        }
        payload.setReleaseStatus(Integer.valueOf(0));
        boolean isTime = this.checkTriggerTime(payload);
        boolean isNew = false;
        boolean isRelese = false;
        ArrayList<String> deleteIds = new ArrayList<String>();
        if (isTime) {
            if ("timing".equals(messageConfigVO.getTriggerWay())) {
                if (!payload.getTriggerTimeExpression().equals(messageConfigVO.getTriggerTimeExpression())) {
                    deleteIds.add("" + payload.getId());
                    isNew = true;
                }
                if (!messageConfigVO.getIsEnable().equals(payload.getIsEnable())) {
                    this.dao.updateXxlJobById("" + payload.getId(), payload.getIsEnable() == 0 ? 1 : 0);
                }
            } else {
                isNew = true;
            }
        } else {
            if ("timing".equals(messageConfigVO.getTriggerWay())) {
                deleteIds.add("" + payload.getId());
            }
            if (payload.getMessageType() == 2) {
                payload.setTriggerTime(LocalDateTime.now());
                payload.setReleaseStatus(Integer.valueOf(3));
                isRelese = true;
            }
        }
        if (deleteIds.size() > 0) {
            this.dao.deleteXxlJobById(deleteIds);
        }
        PrdMessageConfigDO ado = PrdMessageConfigConvert.INSTANCE.toDo(payload);
        ado.setCreator(messageConfigVO.getCreator());
        ado.setCreateUserId(messageConfigVO.getCreateUserId());
        this.getCreateSource(ado);
        ado = this.dao.save(ado);
        if (isNew) {
            this.createXXLJob(ado);
        }
        if (isRelese) {
            PrdMessageConfigVO configVO = PrdMessageConfigConvert.INSTANCE.toVo(ado);
            this.releaseMessage(Arrays.asList(configVO));
        }
        return 0L;
    }

    @Transactional
    public boolean recall(List<Long> keys) {
        this.dao.recall(keys);
        this.dao.deleteUserMessage(keys);
        return true;
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        List<String> adminStrIds = keys.stream().map(String::valueOf).collect(Collectors.toList());
        this.dao.deleteXxlJobById(adminStrIds);
        return true;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
        List<String> adminStrIds = keys.stream().map(String::valueOf).collect(Collectors.toList());
        this.dao.deleteXxlJobById(adminStrIds);
        return true;
    }

    public PrdMessageConfigVO queryByKey(Long key) {
        PrdMessageConfigVO messageConfigVO = this.dao.queryByKey(key);
        this.transferSystemSelection(messageConfigVO);
        String name = this.getNoticeSourceName(messageConfigVO.getId(), messageConfigVO.getNoticeScope(), messageConfigVO.getNoticeSource());
        messageConfigVO.setNoticeSourceName(name);
        return messageConfigVO;
    }

    public String getNoticeSourceName(Long messageId, String noticeScope, String noticeSource) {
        String name = noticeSource;
        if (StringUtils.hasText((String)noticeSource)) {
            if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())) {
                name = this.dao.getOrgNames(messageId);
            }
            if (noticeScope.equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())) {
                ArrayList<String> userNames = new ArrayList<String>();
                for (String sourceId : noticeSource.split(",")) {
                    String userName = this.cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                name = String.join((CharSequence)",", userNames);
            }
            if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())) {
                name = this.dao.getRoleNames(messageId);
            }
        }
        return name;
    }

    public List<TwCommonVO> queryDatas(String noticeScope) {
        ArrayList<TwCommonVO> list = new ArrayList<TwCommonVO>();
        if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())) {
            List<PrdSystemRoleVO> roleVOS = this.daoSysRole.queryList();
            roleVOS.forEach(refVo -> {
                TwCommonVO vo = new TwCommonVO();
                vo.setId(refVo.getId());
                vo.setName(refVo.getRoleName());
                list.add(vo);
            });
        }
        if (noticeScope.equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())) {
            List refVOS = this.organizationService.queryAll(null, null);
            refVOS.forEach(refVo -> {
                TwCommonVO vo = new TwCommonVO();
                vo.setId(refVo.getOrgId());
                vo.setName(refVo.getOrgName());
                list.add(vo);
            });
        }
        if (noticeScope.equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())) {
            PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
            query.setEnabled(Boolean.valueOf(true));
            query.setResourceStatus(SystemDefaultEnum.DefaultResourceStatus.getCode());
            query.setHrStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
            List refVOS = this.employeeService.queryList(query);
            refVOS.forEach(refVo -> {
                TwCommonVO vo = new TwCommonVO();
                vo.setId(refVo.getUserId());
                vo.setName(refVo.getEmployeeName());
                list.add(vo);
            });
        }
        return list;
    }

    public PagingVO<PrdMessageConfigVO> paging(PrdMessageConfigQuery query) {
        PagingVO<PrdMessageConfigVO> messageConfigVOPagingVOs = this.dao.queryPaging(query);
        List configVOS = messageConfigVOPagingVOs.getRecords();
        configVOS.forEach(configVO -> this.transferSystemSelection((PrdMessageConfigVO)configVO));
        return messageConfigVOPagingVOs;
    }

    @Transactional
    public boolean onKeyRelease(List<Long> keys) {
        List<PrdMessageConfigVO> configVOS = this.dao.queryByKeys(keys, 2, null);
        this.releaseMessage(configVOS);
        List<Long> ids = configVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        this.dao.updateAdminStatus(ids);
        List<String> adminStrIds = ids.stream().map(String::valueOf).collect(Collectors.toList());
        this.dao.deleteXxlJobById(adminStrIds);
        return true;
    }

    @Transactional
    public void onJobHandlerRelease(String param) {
        System.out.println("onJobHandlerRelease param::" + param);
        if (StringUtil.isInteger(param)) {
            List operIds;
            ArrayList<Long> messageIds = new ArrayList<Long>();
            messageIds.add(Long.valueOf(param));
            List<PrdMessageConfigVO> configVOS = this.dao.queryByKeys(messageIds, 0, "timing");
            this.releaseMessage(configVOS);
            List<Long> adminIds = configVOS.stream().filter(configVO -> configVO.getMessageType() == 2).map(BaseViewModel::getId).collect(Collectors.toList());
            if (adminIds.size() > 0) {
                this.dao.updateAdminStatus(adminIds);
                List<String> adminStrIds = adminIds.stream().map(String::valueOf).collect(Collectors.toList());
                this.dao.deleteXxlJobById(adminStrIds);
            }
            if ((operIds = configVOS.stream().filter(configVO -> configVO.getMessageType() == 1).map(BaseViewModel::getId).collect(Collectors.toList())).size() > 0) {
                this.dao.updateOperStatus(adminIds);
            }
        }
    }

    public List<TwCommonVO> queryMyDatas(String releaseSource) {
        List<TwCommonVO> list = new ArrayList<TwCommonVO>();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (releaseSource.equals(MessageReleaseSourceEnum.ORG.getCode())) {
            list = this.dao.queryOrgListByUserId(user.getUser().getId());
        }
        if (releaseSource.equals(MessageReleaseSourceEnum.ROLE.getCode())) {
            list = this.dao.queryRoleListByUserId(user.getUser().getId());
        }
        return list;
    }

    public Object sendMessageConfig(PrdMessageConfigVO configVO, Object content, String noticeScope, String noticeSource) {
        String releaseTitle = SpelUtil.parseStringExpression(configVO.getMessageTitle(), content);
        String releaseBody = SpelUtil.parseStringExpression(configVO.getMessageContent(), content);
        configVO.setMessageTitle(releaseTitle);
        configVO.setMessageContent(releaseBody);
        configVO.setNoticeScope(noticeScope);
        configVO.setNoticeSource(noticeSource);
        List<PrdMessageConfigVO> prdMessageConfigVOS = Arrays.asList(configVO);
        this.releaseMessage(prdMessageConfigVOS);
        return prdMessageConfigVOS;
    }

    public void releaseMessage(List<PrdMessageConfigVO> configVOS) {
        if (configVOS != null && configVOS.size() > 0) {
            List<PrdMessageConfigVO> appointRoles;
            List<PrdMessageConfigVO> appointOrgs;
            List<PrdMessageConfigVO> appointUsers;
            ArrayList<PrdUserMessageDO> messageDOS = new ArrayList<PrdUserMessageDO>();
            List<PrdMessageConfigVO> allUsers = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.WHOLE.getCode())).collect(Collectors.toList());
            if (allUsers != null && allUsers.size() > 0) {
                this.releaseMessageAllUser(allUsers, messageDOS);
            }
            if ((appointUsers = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())).collect(Collectors.toList())) != null && appointUsers.size() > 0) {
                this.releaseMessageAppointUser(appointUsers, messageDOS);
            }
            if ((appointOrgs = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())).collect(Collectors.toList())) != null && appointOrgs.size() > 0) {
                this.releaseMessageAppointOrg(appointOrgs, messageDOS);
            }
            if ((appointRoles = configVOS.stream().filter(configVO -> configVO.getNoticeScope().equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())).collect(Collectors.toList())) != null && appointRoles.size() > 0) {
                this.releaseMessageAppointRole(appointRoles, messageDOS);
            }
            if (messageDOS.size() > 0) {
                this.dao.saveUserMessages(messageDOS);
            }
        }
    }

    void releaseMessageAppointRole(List<PrdMessageConfigVO> appointRoles, List<PrdUserMessageDO> messageDOS) {
        PrdMessageConfigVO messageConfigVO;
        List<Long> orgRefIds = appointRoles.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        HashMap emailMap = new HashMap();
        HashMap weComMap = new HashMap();
        List<String[]> messageVOS = this.dao.getRoleMessageDatas(orgRefIds);
        for (String[] stringArray : messageVOS) {
            List<Long> userIds;
            if (stringArray[3].equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                PrdMessageConfigVO messageConfigVO2 = appointRoles.stream().filter(configVO -> configVO.getId().longValue() == Long.valueOf(messageVO[0]).longValue()).findFirst().get();
                this.addMessageDO(messageDOS, Long.valueOf(stringArray[1]), messageConfigVO2);
            }
            if (stringArray[3].equals(MessageNoticeWayEnum.EMAIL.getCode())) {
                long messageId = Long.valueOf(stringArray[0]);
                userIds = (ArrayList<Long>)emailMap.get(messageId);
                if (userIds == null) {
                    userIds = new ArrayList<Long>();
                    emailMap.put(messageId, userIds);
                }
                userIds.add(Long.valueOf(stringArray[1]));
            }
            if (!stringArray[3].equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) continue;
            long messageId = Long.valueOf(stringArray[0]);
            userIds = (List)weComMap.get(messageId);
            if (userIds == null) {
                userIds = new ArrayList();
                weComMap.put(messageId, userIds);
            }
            userIds.add(Long.valueOf(stringArray[1]));
        }
        if (!emailMap.isEmpty()) {
            for (Map.Entry entry : emailMap.entrySet()) {
                List<String> emails = this.dao.queryUserEmailByIds((List)entry.getValue());
                messageConfigVO = appointRoles.stream().filter(configVO -> configVO.getId().longValue() == ((Long)emailData.getKey()).longValue()).findFirst().get();
                this.sendEmail(emails, messageConfigVO.getMessageTitle(), messageConfigVO.getMessageContent());
            }
        }
        if (!weComMap.isEmpty()) {
            for (Map.Entry entry : weComMap.entrySet()) {
                List<String> weComs = this.dao.queryUserWeComByIds((List)entry.getValue());
                messageConfigVO = appointRoles.stream().filter(configVO -> configVO.getId().longValue() == ((Long)weComData.getKey()).longValue()).findFirst().get();
                this.sendWeCom(weComs, messageConfigVO);
            }
        }
    }

    void releaseMessageAppointOrg(List<PrdMessageConfigVO> appointOrgs, List<PrdUserMessageDO> messageDOS) {
        PrdMessageConfigVO messageConfigVO;
        List<Long> orgRefIds = appointOrgs.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        HashMap emailMap = new HashMap();
        HashMap weComMap = new HashMap();
        List<String[]> messageVOS = this.dao.getOrgMessageDatas(orgRefIds);
        for (String[] stringArray : messageVOS) {
            List<Long> userIds;
            if (stringArray[3].equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                PrdMessageConfigVO messageConfigVO2 = appointOrgs.stream().filter(configVO -> configVO.getId().longValue() == Long.valueOf(messageVO[0]).longValue()).findFirst().get();
                this.addMessageDO(messageDOS, Long.valueOf(stringArray[1]), messageConfigVO2);
            }
            if (stringArray[3].equals(MessageNoticeWayEnum.EMAIL.getCode())) {
                long messageId = Long.valueOf(stringArray[0]);
                userIds = (ArrayList<Long>)emailMap.get(messageId);
                if (userIds == null) {
                    userIds = new ArrayList<Long>();
                    emailMap.put(messageId, userIds);
                }
                userIds.add(Long.valueOf(stringArray[1]));
            }
            if (!stringArray[3].equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) continue;
            long messageId = Long.valueOf(stringArray[0]);
            userIds = (List)weComMap.get(messageId);
            if (userIds == null) {
                userIds = new ArrayList();
                weComMap.put(messageId, userIds);
            }
            userIds.add(Long.valueOf(stringArray[1]));
        }
        if (!emailMap.isEmpty()) {
            for (Map.Entry entry : emailMap.entrySet()) {
                List<String> emails = this.dao.queryUserEmailByIds((List)entry.getValue());
                messageConfigVO = appointOrgs.stream().filter(configVO -> configVO.getId().longValue() == ((Long)emailData.getKey()).longValue()).findFirst().get();
                this.sendEmail(emails, messageConfigVO.getMessageTitle(), messageConfigVO.getMessageContent());
            }
        }
        if (!weComMap.isEmpty()) {
            for (Map.Entry entry : weComMap.entrySet()) {
                List<String> weComs = this.dao.queryUserWeComByIds((List)entry.getValue());
                messageConfigVO = appointOrgs.stream().filter(configVO -> configVO.getId().longValue() == ((Long)weComData.getKey()).longValue()).findFirst().get();
                this.sendWeCom(weComs, messageConfigVO);
            }
        }
    }

    void releaseMessageAppointUser(List<PrdMessageConfigVO> appointUsers, List<PrdUserMessageDO> messageDOS) {
        for (PrdMessageConfigVO configVO : appointUsers) {
            if (!StringUtils.hasText((String)configVO.getNoticeSource())) continue;
            String[] userIds = configVO.getNoticeSource().split(",");
            if (configVO.getNoticeWay().equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                for (int i = 0; i < userIds.length; ++i) {
                    this.addMessageDO(messageDOS, Long.valueOf(userIds[i]), configVO);
                }
            }
            List<Long> operaIds = Arrays.asList(userIds).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toList());
            if (configVO.getNoticeWay().equals(MessageNoticeWayEnum.EMAIL.getCode())) {
                List<String> emails = this.dao.queryUserEmailByIds(operaIds);
                this.sendEmail(emails, configVO.getMessageTitle(), configVO.getMessageContent());
            }
            if (!configVO.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) continue;
            List<String> weComs = this.dao.queryUserWeComByIds(operaIds);
            this.sendWeCom(weComs, configVO);
        }
    }

    void releaseMessageAllUser(List<PrdMessageConfigVO> allUsers, List<PrdUserMessageDO> messageDOS) {
        List<Long> userIds = null;
        List<String> emails = null;
        List<String> weComs = null;
        for (PrdMessageConfigVO messageVO : allUsers) {
            if (messageVO.getNoticeWay().equals(MessageNoticeWayEnum.INSTATION.getCode())) {
                if (userIds == null) {
                    userIds = this.dao.queryAllUser();
                }
                for (Long userId : userIds) {
                    this.addMessageDO(messageDOS, userId, messageVO);
                }
            }
            if (messageVO.getNoticeWay().equals(MessageNoticeWayEnum.EMAIL.getCode())) {
                PrdSystemSettingVO systemSetting = this.cacheUtil.getSystemSetting(this.message_email);
                if (systemSetting != null) {
                    emails = Arrays.asList(systemSetting.getSettingValue());
                }
                this.sendEmail(emails, messageVO.getMessageTitle(), messageVO.getMessageContent());
            }
            if (!messageVO.getNoticeWay().equals(MessageNoticeWayEnum.ENTERPRISE_WECHAT.getCode())) continue;
            if (weComs == null) {
                weComs = this.dao.queryUserWeComByIds(new ArrayList<Long>());
            }
            this.sendWeCom(weComs, messageVO);
        }
    }

    void sendWeCom(List<String> weComs, PrdMessageConfigVO messageConfigVO) {
        String touser = org.apache.commons.lang3.StringUtils.join((Iterable)weComs.stream().filter(weCom -> StringUtils.hasText((String)weCom)).collect(Collectors.toList()), (String)"|");
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("content", messageConfigVO.getMessageContent());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("touser", touser);
        map.put("msgtype", "text");
        map.put("text", contentMap);
        this.qyWxCommunicationService.sendMessageToUser(map);
    }

    void sendEmail(List<String> emails, String subject, String text) {
        JavaMailPayload mailPayload = new JavaMailPayload();
        mailPayload.setReceiveEmails(emails);
        mailPayload.setSubject(subject);
        mailPayload.setText(text);
        this.mailUtil.sendEmailAsyncByAdmin(mailPayload);
    }

    void addMessageDO(List<PrdUserMessageDO> messageDOS, Long userId, PrdMessageConfigVO mvo) {
        int sortIndex = 99;
        if (StringUtils.hasText((String)mvo.getMessageTag())) {
            sortIndex = this.cacheUtil.transferSystemSelectionSortIndex(FunctionSelectionEnum.MessageTag.getCode(), mvo.getMessageTag());
        }
        PrdUserMessageDO messageDO = new PrdUserMessageDO();
        messageDO.setMessageId(mvo.getId());
        messageDO.setSortIndex(sortIndex);
        messageDO.setUserId(userId);
        messageDO.setContentBigType(mvo.getContentBigType());
        messageDO.setContentType(mvo.getContentType());
        messageDO.setCreateSource(mvo.getCreateSource());
        messageDO.setMessageContent(mvo.getMessageContent());
        messageDO.setMessageTag(mvo.getMessageTag());
        messageDO.setMessageTitle(mvo.getMessageTitle());
        messageDO.setNoticeScope(mvo.getNoticeScope());
        messageDO.setNoticeSource(mvo.getNoticeSource());
        messageDO.setTenantId(mvo.getTenantId());
        messageDOS.add(messageDO);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void addJobMessage(Long objectId, String action, LocalDateTime triggerTime, String createSource, String noticeSource, String title, String content, String urlTitle, String url) {
        StringBuffer messageContent = new StringBuffer();
        messageContent.append("<br/><br/>");
        messageContent.append("<div style='font-size:16px;'>");
        messageContent.append(String.format("<span style='font-size:18px;'>%s</span>", content));
        if (urlTitle != null) {
            messageContent.append(String.format("<p><a href=\"%s\">%s</a></p>", url, urlTitle));
        }
        messageContent.append("</div>");
        messageContent.append("<br/><br/>");
        messageContent.append("<br/><br/>");
        PrdMessageConfigPayload payload = new PrdMessageConfigPayload();
        payload.setObjectId(objectId);
        payload.setAction(action);
        payload.setMessageTitle(title);
        payload.setMessageContent(messageContent.toString());
        payload.setMessageType(Integer.valueOf(2));
        payload.setContentBigType("businessMessage");
        payload.setContentType("crm");
        payload.setMessageTag("important");
        payload.setNoticeWay("instation");
        payload.setReleaseSource("profileMessage");
        payload.setCreateSource(createSource);
        payload.setNoticeScope("appoint_people");
        payload.setNoticeSource(noticeSource);
        payload.setTriggerTime(triggerTime);
        PrdMessageConfigVO insert = this.insert(payload);
    }

    public List<PrdMessageConfigVO> queryByObjectIdAndAction(Long objectId, String action) {
        List<PrdMessageConfigDO> messageConfig = this.dao.queryByObjectIdAndAction(objectId, action);
        List<PrdMessageConfigVO> prdMessageConfigVO = messageConfig.stream().map(e -> PrdMessageConfigConvert.INSTANCE.toVo((PrdMessageConfigDO)e)).collect(Collectors.toList());
        return prdMessageConfigVO;
    }

    public PrdMessageConfigVO queryByMessageCode(String messageCode) {
        return this.dao.queryByMessageCode(messageCode);
    }

    void getCreateSource(PrdMessageConfigDO ado) {
        String releaseSource = ado.getReleaseSource();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (releaseSource.equals("profileMessage") && ado.getCreateSource() != null && user != null) {
            ado.setCreateSource(user.getUser().getFirstName());
        }
    }

    void transferSystemSelection(PrdMessageConfigVO vo) {
        vo.setContentTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentType.getCode(), vo.getContentType()));
        vo.setContentBigTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentBigType.getCode(), vo.getContentBigType()));
        vo.setReleaseSourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ReleaseSource.getCode(), vo.getReleaseSource()));
        vo.setNoticeWayName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.NoticeWay.getCode(), vo.getNoticeWay()));
        vo.setTriggerWayName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.TriggerWay.getCode(), vo.getTriggerWay()));
        vo.setMessageTagName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.MessageTag.getCode(), vo.getMessageTag()));
        vo.setNoticeScopeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.NoticeScope.getCode(), vo.getNoticeScope()));
    }

    public PrdMessageConfigServiceImpl(PrdMessageConfigDAO dao, PrdSystemRoleDAO daoSysRole, CacheUtil cacheUtil, JavaMailUtil mailUtil, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService organizationService, QyWxCommunicationService qyWxCommunicationService) {
        this.dao = dao;
        this.daoSysRole = daoSysRole;
        this.cacheUtil = cacheUtil;
        this.mailUtil = mailUtil;
        this.employeeService = employeeService;
        this.organizationService = organizationService;
        this.qyWxCommunicationService = qyWxCommunicationService;
    }
}

