package com.elitesland.tw.tw5.server.yeedoc.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.yeedoc.service.YeedocWorkflowService;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 易稻壳工作流交互
 *
 * @author carl
 * @date 2023-07-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class YeedocWorkflowServiceImpl extends BaseServiceImpl implements YeedocWorkflowService {
    private final WorkflowUtil workflowUtil;

    @Override
    public ProcessInfo submitProcess(StartProcessPayload payload) {
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(payload);
        return processInfo;
    }
}
