/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;

public class BeanUtil {
    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static Object getFieldValueByFieldName(String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getAllFieldValueByFieldName(String fieldName, Object object) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        field.setAccessible(true);
        return field.get(object);
    }

    public static void setFieldValueByFieldName(String key, String value, Object object) {
        Object returnStr = null;
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                returnStr = field.get(object);
                if (field.getAnnotation(JsonProperty.class) != null) {
                    JsonProperty annotation = field.getAnnotation(JsonProperty.class);
                    if (annotation == null) continue;
                    System.out.println("" + annotation);
                    String jsonPropertyValue = annotation.value();
                    if (!key.equals(jsonPropertyValue)) continue;
                    field.set(object, value);
                } else {
                    String fieldName = field.getName();
                    if (!key.equals(fieldName)) continue;
                    field.set(object, value);
                }
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static Field getFieldByClasss(String fieldName, Object object) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return field;
    }

    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            Field[] declaredFields = clazz.getDeclaredFields();
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(declaredFields)));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        return fieldList.toArray(fields);
    }

    public static Map<String, String> getAllFieldsAndName(Class<?> clazz, List<String> withChildrenFields) {
        List<Field> allFields = BeanUtil.getFields(clazz, withChildrenFields);
        LinkedHashMap<String, String> fieldWithName = new LinkedHashMap<String, String>();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(Comment.class)) continue;
            Comment declaredAnnotation = field.getDeclaredAnnotation(Comment.class);
            String columnName = declaredAnnotation.value();
            fieldWithName.put(field.getName(), columnName);
        }
        return fieldWithName;
    }

    public static List<Field> getFields(Class<?> clazz, List<String> withChildrenFields) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declaredFields));
        for (Field field : declaredFields) {
            if (withChildrenFields == null || withChildrenFields.size() <= 0) continue;
            for (String withChildrenField : withChildrenFields) {
                if (!field.getName().equals(withChildrenField)) continue;
                fields.remove(field);
                List<Field> childFields = BeanUtil.getFields(field.getType(), null);
                fields.addAll(childFields);
            }
        }
        return fields;
    }

    public static boolean isPrivate(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static Map<String, Object> beanToMap(Object bean) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Method[] methods;
            Class<?> c = bean.getClass();
            for (Method method : methods = c.getMethods()) {
                Object value;
                String name = method.getName();
                Object key = "";
                if (name.startsWith("get")) {
                    key = name.substring(3);
                }
                if (((String)key).length() <= 0 || !Character.isUpperCase(((String)key).charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (((String)key).length() == 1) {
                    key = ((String)key).toLowerCase();
                } else if (!Character.isUpperCase(((String)key).charAt(1))) {
                    key = ((String)key).substring(0, 1).toLowerCase() + ((String)key).substring(1);
                }
                if ("class".equals(((String)key).toLowerCase()) || (value = method.invoke(bean, new Object[0])) == null) continue;
                hashMap.put((String)key, value);
            }
        }
        catch (Throwable var9) {
            var9.printStackTrace();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T mapToBean(Class<T> clazz, Map<String, Object> map, List<String> excludeKeys) {
        T bean = null;
        try {
            bean = clazz.newInstance();
            for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
                String typeName;
                String key = stringObjectEntry.getKey();
                if (excludeKeys.contains(key)) continue;
                Object value = stringObjectEntry.getValue();
                Field field = BeanUtil.getClassField(clazz, key);
                if (field == null) continue;
                String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
                Method method = clazz.getMethod(methodName, field.getType());
                if (value != null && value instanceof Integer && (typeName = field.getGenericType().getTypeName()).equals("java.lang.Long")) {
                    value = (long)((Integer)value).intValue();
                }
                if (value != null && (typeName = field.getGenericType().getTypeName()).equals("java.time.LocalDate")) {
                    value = LocalDate.parse(value.toString());
                }
                try {
                    try {
                        method.invoke(bean, value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }

    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
            if (!declaredField.getName().equals(fieldName)) continue;
            return declaredField;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (null != superclass) {
            return BeanUtil.getClassField(superclass, fieldName);
        }
        return null;
    }

    public static boolean compareObject(Object oldObject, Object newObject) {
        Map<String, Map<String, Object>> resultMap = BeanUtil.compareFields(oldObject, newObject);
        return resultMap.size() <= 0;
    }

    public static Map<String, Map<String, Object>> compareFields(Object oldObject, Object newObject) {
        HashMap map = null;
        try {
            if (oldObject.getClass() == newObject.getClass()) {
                PropertyDescriptor[] pds;
                map = new HashMap();
                Class<?> clazz = oldObject.getClass();
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                    HashMap<String, Object> valueMap;
                    String name = pd.getName();
                    Method readMethod = pd.getReadMethod();
                    Object oldValue = readMethod.invoke(oldObject, new Object[0]);
                    Object newValue = readMethod.invoke(newObject, new Object[0]);
                    if (oldValue instanceof List || newValue instanceof List) continue;
                    if (oldValue instanceof Timestamp) {
                        oldValue = new Date(((Timestamp)oldValue).getTime());
                    }
                    if (newValue instanceof Timestamp) {
                        newValue = new Date(((Timestamp)newValue).getTime());
                    }
                    if (oldValue == null && newValue == null) continue;
                    if (oldValue == null && newValue != null) {
                        valueMap = new HashMap<String, Object>();
                        valueMap.put("oldValue", oldValue);
                        valueMap.put("newValue", newValue);
                        map.put(name, valueMap);
                        continue;
                    }
                    if (oldValue.equals(newValue)) continue;
                    valueMap = new HashMap();
                    valueMap.put("oldValue", oldValue);
                    valueMap.put("newValue", newValue);
                    map.put(name, valueMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

