/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.dao;

import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAccountVO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAccountDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbAccountDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbAccountRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class PrdAbAccountDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbAccountRepo repo;
    private final QPrdAbAccountDO qdo = QPrdAbAccountDO.prdAbAccountDO;

    public Long queryTW4IdById(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.accountIdV4).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (Long)jpaQuery.fetchFirst();
    }

    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.accountIdV4).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdAbAccountDO save(PrdAbAccountDO ado) {
        return (PrdAbAccountDO)((Object)this.repo.save((Object)ado));
    }

    private JPAQuery<PrdAbAccountVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdAbAccountVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.accountType, this.qdo.depositBank, this.qdo.depositCity, this.qdo.depositBankOutlet, this.qdo.accountName, this.qdo.accountNo, this.qdo.currency, this.qdo.remark, this.qdo.defaultFlag})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    public List<PrdAbAccountVO> queryList(Long bookId) {
        JPAQuery<PrdAbAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PrdAbAccountVO> queryList(Long bookId, String accountType, Boolean defaultFlag, String accountNo) {
        JPAQuery<PrdAbAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        if (StringUtils.hasText((String)accountType)) {
            jpaQuery.where((Predicate)this.qdo.accountType.eq((Object)accountType));
        }
        if (null != defaultFlag) {
            jpaQuery.where((Predicate)this.qdo.defaultFlag.eq(defaultFlag));
        }
        if (StringUtils.hasText((String)accountNo)) {
            jpaQuery.where((Predicate)this.qdo.accountNo.eq((Object)accountNo));
        }
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public PrdAbAccountDAO(JPAQueryFactory jpaQueryFactory, PrdAbAccountRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

