/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedoc.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/yeedoc-{procDefKey}/callBack"})
@Transactional
public class YeedocCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(YeedocCallBackController.class);
    private final HttpUtil httpUtil;
    @Value(value="${yeedoc.processAdvanceUrl:testUrl}")
    private String processAdvanceUrl;
    @Value(value="${yeedoc.processStatusChangeUrl:testUrl}")
    private String processStatusChangeUrl;
    @Value(value="${yeedoc.taskAssigneeUrl:testUrl}")
    private String taskAssigneeUrl;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        String result = this.httpUtil.sendPost(this.taskAssigneeUrl, BeanUtil.beanToMap(payload));
        if (result == null || "".equals(result)) {
            throw TwException.error("433", "\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba-\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
        }
        try {
            Map parse = (Map)JSON.parse((String)result);
            if (("" + parse.get("IsSuccess")).equals("true")) {
                if (parse.get("Data") != null) {
                    return (ArrayList)parse.get("Data");
                }
                return null;
            }
            String errmsg = "" + parse.get("Message");
            throw TwException.error("" + parse.get("Code"), "\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba-\u8bf7\u6c42\u6570\u636e\u5931\u8d25,\u8be6\u60c5\uff1a" + errmsg);
        }
        catch (Exception ex) {
            throw TwException.error("434", "\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba-\u8bf7\u6c42\u6570\u636e\u5931\u8d25,\u8be6\u60c5\uff1a" + result);
        }
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        String result = this.httpUtil.sendPost(this.processAdvanceUrl, BeanUtil.beanToMap(payload));
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u7ed3\u679c: {}", (Object)result);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String result = this.httpUtil.sendPost(this.processStatusChangeUrl, BeanUtil.beanToMap(payload));
        log.info("\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        log.info("\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u540e\u56de\u8c03\u7ed3\u679c: {}", (Object)result);
    }

    public YeedocCallBackController(HttpUtil httpUtil) {
        this.httpUtil = httpUtil;
    }
}

