package com.elitesland.tw.tw5.server.prd.schedule.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author zoey
 * @Description:日程参与成员表
 * @date 2022/4/19 - 21:06
 */
@Entity
@Table(name = "prd_schedule_attendees", indexes = {@Index(name = "schedule_index", columnList = "schedule_id"),@Index(name = "user_index", columnList = "user_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_schedule_attendees", comment = "日程参与成员表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdScheduleAttendeesDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("日程参与成员id")
    @Column(name = "user_id")
    private Long userId;

    @Comment("日程id")
    @Column(name = "schedule_id")
    private Long secheduleId;


}
