package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionDataPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionDataQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionDataService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionDataVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.SystemConstants;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 系统功能数据权限项
 *
 * @author wangding
 */
@Api("系统设置数据权限项")
@RestController
@RequiredArgsConstructor
@RequestMapping(SystemConstants.API_SYSTEM)
@Slf4j
public class PrdSystemFunctionDataController {

    private final PrdSystemFunctionDataService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/function/data/insert")
    public TwOutputUtil insert(PrdSystemFunctionDataPayload entity) {
        PrdSystemFunctionDataVO vo = service.insert(entity);
        if (vo != null) {
            return TwOutputUtil.ok(vo);
        } else {
            return TwOutputUtil.error().addError("", "", vo);
        }

    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/function/data/paging")
    public TwOutputUtil findByConditionPaging(PrdSystemFunctionDataQuery query) {
        PagingVO<PrdSystemFunctionDataVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/function/data/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/function/data/update")
    public TwOutputUtil update(PrdSystemFunctionDataPayload entity) {
        long returnNum = service.update(entity);
        if (returnNum < 0) {
            return TwOutputUtil.error().addError("", "", null);
        } else {
            return TwOutputUtil.ok();
        }
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/function/data/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemFunctionDataVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

}
