package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemLogDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemLogRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemLogDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemLogRepo repo;
//    private final QCrmLogDO qdo = QCrmLogDO.crmLogDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemLogDO save(PrdSystemLogDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdSystemLogDO> saveAll(List<PrdSystemLogDO> dos) {
        return repo.saveAll(dos);
    }


    public List<PrdSystemLogDO> queryByObjectIdAndObjectType(Long objectId, String logObjectType) {
        return repo.findByObjectIdAndLogObjectOrderByCreateTimeDesc(objectId,logObjectType);
    }

    public Specification<PrdSystemLogDO> getSpec(PrdSystemLogQuery query) {
        Specification<PrdSystemLogDO> querySpecifi = (root, criteriaQuery, cb) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (!StringUtils.isEmpty(query.getLogContent())) {
                predicates.add(cb.like(root.get("logContent").as(String.class), SqlUtil.toSqlLikeString(query.getLogContent())));
            }
            if (!StringUtils.isEmpty(query.getLogObject())) {
                predicates.add(cb.equal(root.get("logObject").as(String.class), query.getLogObject()));
            }
            if (!ObjectUtils.isEmpty(query.getObjectId())) {
                predicates.add(cb.equal(root.get("objectId").as(String.class), query.getObjectId()));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };

        return querySpecifi;
    }

    public Page<PrdSystemLogDO> findAll(Specification<PrdSystemLogDO> spec, Pageable pageable) {
        pageable= PageUtil.defaultSort(pageable);
        return repo.findAll(spec, pageable);
    }
}
