package com.elitesland.tw.tw5.server.yeedoc.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author carl
 * @date 2023/07/11
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "YEEDOC_{procDefKey}" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class YeedocCallBackController implements WorkflowCallBack {
    private final HttpUtil httpUtil;

    @Value("${yeedoc.processAdvanceUrl:testUrl}")
    private String processAdvanceUrl;

    @Value("${yeedoc.processStatusChangeUrl:testUrl}")
    private String processStatusChangeUrl;
    @Value("${yeedoc.taskAssigneeUrl:testUrl}")
    private String taskAssigneeUrl;
    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        String result = httpUtil.sendPost(taskAssigneeUrl, BeanUtil.beanToMap(payload));

        ArrayList<String> userIds = (ArrayList<String>)httpUtil.getYeedocResultData(result);

        return userIds;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {

        String result = httpUtil.sendPost(processAdvanceUrl, BeanUtil.beanToMap(payload));

        log.info("任务创建后回调参数: {}", payload);
        log.info("任务创建后回调结果: {}", result);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
    }


    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {

        String result = httpUtil.sendPost(processStatusChangeUrl, BeanUtil.beanToMap(payload));

        log.info("任务状态变更后回调参数: {}", payload);
        log.info("任务状态变更后回调结果: {}", result);
    }
}
