/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.server.common.TwException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpUtil<k, v> {
    @Value(value="${tw4.isSync}")
    private Boolean tw4_isSync = false;
    @Value(value="${tw4.url}")
    private String tw4_url;
    private final RestTemplate restTemplate;

    public HttpEntity<Map<String, Object>> generatePostJson(Map<String, Object> jsonMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("Source", "1");
        HttpEntity httpEntity = new HttpEntity(jsonMap, (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    public String generateRequestParameters(String uri, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder(uri);
        if (ObjectUtil.isNotEmpty(params)) {
            sb.append("?");
            for (Map.Entry<String, Object> map : params.entrySet()) {
                sb.append((Object)map.getKey()).append("=").append(map.getValue()).append("&");
            }
            uri = sb.substring(0, sb.length() - 1);
            return uri;
        }
        return sb.toString();
    }

    public String sendGetExchange(String uri, Map<String, Object> uriMap, HttpEntity httpEntity) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.generateRequestParameters(uri, uriMap), HttpMethod.GET, httpEntity, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public String sendGet(String uri, Map<String, Object> uriMap, Object ... uriVariables) {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.generateRequestParameters(uri, uriMap), String.class, uriVariables);
        return (String)responseEntity.getBody();
    }

    public String sendPost(String uri, Map<String, Object> jsonMap) {
        ResponseEntity apiResponse = this.restTemplate.postForEntity(uri, this.generatePostJson(jsonMap), String.class, new Object[0]);
        return (String)apiResponse.getBody();
    }

    public String sendSyncPost(String uri, Map<String, Object> jsonMap) {
        if (this.tw4_isSync.booleanValue()) {
            String result = cn.hutool.http.HttpUtil.post((String)(this.tw4_url + uri), jsonMap);
            return result;
        }
        return "{\"ok\":true}";
    }

    public String sendSyncGet(String uri, Map<String, Object> uriMap) {
        if (this.tw4_isSync.booleanValue()) {
            String result = cn.hutool.http.HttpUtil.get((String)(this.tw4_url + uri), uriMap);
            return result;
        }
        return "{\"ok\":true}";
    }

    public String geResultData(String result) {
        return "";
    }

    public Object getYeedocResultData(String result) {
        if (result == null || "".equals(result)) {
            throw TwException.error("433", "\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba-\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
        }
        try {
            Map parse = (Map)JSON.parse((String)result);
            if (("" + parse.get("IsSuccess")).equals("true")) {
                if (parse.get("Data") != null) {
                    return parse.get("Data");
                }
                return null;
            }
            String errmsg = "" + parse.get("Message");
            throw TwException.error("" + parse.get("Code"), "\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba-\u8bf7\u6c42\u6570\u636e\u5931\u8d25,\u8be6\u60c5\uff1a" + errmsg);
        }
        catch (Exception ex) {
            throw TwException.error("434", "\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba-\u8bf7\u6c42\u6570\u636e\u5931\u8d25,\u8be6\u60c5\uff1a" + result);
        }
    }

    public String geStrItem(String result, String itemName, String errorMsg) {
        Map parse = (Map)JSON.parse((String)result);
        if (parse.get("errcode").equals(0)) {
            if (parse.get(itemName) != null) {
                return (String)parse.get(itemName);
            }
            return null;
        }
        String errmsg = (String)parse.get("errmsg");
        errmsg = errmsg.split(",")[0];
        throw TwException.error(parse.get("errcode").toString(), errorMsg + ",\u8be6\u60c5\uff1a" + errmsg);
    }

    public Map sendGetCallMap(String uri, Map<String, Object> uriMap) {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.generateRequestParameters(uri, uriMap), Map.class, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    public HttpUtil(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

