/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.office.service.configurers.implementations;

import com.elitesland.tw.tw5.server.prd.office.models.enums.Action;
import com.elitesland.tw.tw5.server.prd.office.models.enums.DocumentType;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.FileModel;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.Permission;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.FileConfigurer;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.implementations.DefaultDocumentConfigurer;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.wrappers.DefaultDocumentWrapper;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.wrappers.DefaultFileWrapper;
import com.elitesland.tw.tw5.server.prd.office.util.file.FileUtility;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DefaultFileConfigurer
implements FileConfigurer<DefaultFileWrapper> {
    @Autowired
    private ObjectFactory<FileModel> fileModelObjectFactory;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private DefaultDocumentConfigurer defaultDocumentConfigurer;

    @Override
    public void configure(FileModel fileModel, DefaultFileWrapper wrapper) {
        if (fileModel != null) {
            String fileName = wrapper.getFileName();
            Action action = wrapper.getAction();
            DocumentType documentType = this.fileUtility.getDocumentType(fileName);
            fileModel.setDocumentType(documentType);
            fileModel.setType(wrapper.getType());
            Permission userPermissions = new Permission();
            String fileExt = this.fileUtility.getFileExtension(wrapper.getFileName());
            Boolean canEdit = this.fileUtility.getEditedExts().contains(fileExt);
            if ((!canEdit.booleanValue() && action.equals((Object)Action.edit) || action.equals((Object)Action.fillForms)) && this.fileUtility.getFillExts().contains(fileExt)) {
                canEdit = true;
                wrapper.setAction(Action.fillForms);
            }
            wrapper.setCanEdit(canEdit);
            DefaultDocumentWrapper documentWrapper = DefaultDocumentWrapper.builder().fileName(fileName).permission(this.updatePermissions(userPermissions, action, canEdit)).favorite(wrapper.getUser().getFavorite()).build();
            this.defaultDocumentConfigurer.configure(fileModel.getDocument(), documentWrapper);
        }
    }

    @Override
    public FileModel getFileModel(DefaultFileWrapper wrapper) {
        FileModel fileModel = (FileModel)this.fileModelObjectFactory.getObject();
        this.configure(fileModel, wrapper);
        return fileModel;
    }

    private Permission updatePermissions(Permission userPermissions, Action action, Boolean canEdit) {
        userPermissions.setComment(!action.equals((Object)Action.view) && !action.equals((Object)Action.fillForms) && !action.equals((Object)Action.embedded) && !action.equals((Object)Action.blockcontent));
        userPermissions.setFillForms(!action.equals((Object)Action.view) && !action.equals((Object)Action.comment) && !action.equals((Object)Action.embedded) && !action.equals((Object)Action.blockcontent));
        userPermissions.setReview(canEdit != false && (action.equals((Object)Action.review) || action.equals((Object)Action.edit)));
        userPermissions.setEdit(canEdit != false && (action.equals((Object)Action.view) || action.equals((Object)Action.edit) || action.equals((Object)Action.filter) || action.equals((Object)Action.blockcontent)));
        return userPermissions;
    }
}

