/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedoc.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.yeedoc.service.YeedocWorkflowService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class YeedocWorkflowServiceImpl
extends BaseServiceImpl
implements YeedocWorkflowService {
    private static final Logger log = LoggerFactory.getLogger(YeedocWorkflowServiceImpl.class);
    private final WorkflowUtil workflowUtil;
    private final HttpUtil httpUtil;
    @Value(value="${yeedoc.queryGroupTypeUrl:https://yeedoc-test.tw.elitesland.com/userapi/Organization/GetGroupTypes}")
    private String queryGroupTypeUrl;
    @Value(value="${yeedoc.queryGroupDataUrl:https://yeedoc-test.tw.elitesland.com/userapi/Organization/GetGroupDataByGroupTypeId}")
    private String queryGroupDataUrl;

    public ProcessInfo submitProcess(StartProcessPayload payload) {
        ProcessInfo processInfo = this.workflowUtil.startProcess(payload);
        return processInfo;
    }

    public Object queryGroupType() {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("Source", "1");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        String result = this.httpUtil.sendGetExchange(this.queryGroupTypeUrl, null, httpEntity);
        Object yeedocResultData = this.httpUtil.getYeedocResultData(result);
        return yeedocResultData;
    }

    public Object queryGroupData(String key) {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("Source", "1");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", key);
        String result = this.httpUtil.sendGetExchange(this.queryGroupDataUrl, map, httpEntity);
        Object yeedocResultData = this.httpUtil.getYeedocResultData(result);
        return yeedocResultData;
    }

    public YeedocWorkflowServiceImpl(WorkflowUtil workflowUtil, HttpUtil httpUtil) {
        this.workflowUtil = workflowUtil;
        this.httpUtil = httpUtil;
    }
}

