/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.log.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.log.convert.ComLogConvert;
import com.elitesland.tw.tw5.server.common.log.dao.ComLogDAO;
import com.elitesland.tw.tw5.server.common.log.entity.ComLogDO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComLogServiceImpl
implements ComLogService {
    private static final Logger log = LoggerFactory.getLogger(ComLogServiceImpl.class);
    private final ComLogDAO dao;

    @Transactional(rollbackFor={Exception.class})
    public ComLogVO insert(ComLogPayload payload) {
        ComLogDO comLogDO = ComLogConvert.INSTANCE.toDo(payload);
        return ComLogConvert.INSTANCE.toVo(this.dao.save(comLogDO));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ComLogVO> insertBacth(List<ComLogPayload> payloads) {
        ArrayList<ComLogDO> dos = new ArrayList<ComLogDO>();
        payloads.forEach(payload -> dos.add(ComLogConvert.INSTANCE.toDo((ComLogPayload)payload)));
        this.dao.saveAll(dos);
        return null;
    }

    public ComLogVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public List<ComLogVO> queryList(ComLogQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public PagingVO<ComLogVO> paging(ComLogQuery query) {
        return this.dao.queryPaging(query);
    }

    public ComLogServiceImpl(ComLogDAO dao) {
        this.dao = dao;
    }
}

