/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractCategoryPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractCategoryQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractCategoryService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractCategoryVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.sale.convert.SaleContractCategoryConvert;
import com.elitesland.tw.tw5.server.prd.sale.entity.SaleContractCategoryDO;
import com.elitesland.tw.tw5.server.prd.sale.repo.SaleContractCategoryRepo;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SaleContractCategoryServiceImpl
implements SaleContractCategoryService {
    private static final Logger log = LoggerFactory.getLogger(SaleContractCategoryServiceImpl.class);
    private final SaleContractCategoryRepo repo;

    @Transactional(rollbackFor={Exception.class})
    public SaleContractCategoryVO insert(SaleContractCategoryPayload payload) {
        SaleContractCategoryDO entityDo = SaleContractCategoryConvert.INSTANCE.toDo(payload);
        this.repo.save(entityDo);
        return SaleContractCategoryConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleContractCategoryVO update(SaleContractCategoryPayload payload) {
        SaleContractCategoryDO entity = this.repo.findById(payload.getId()).orElseGet(SaleContractCategoryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SaleContractCategoryDO entityDo = SaleContractCategoryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleContractCategoryConvert.INSTANCE.toVo((SaleContractCategoryDO)this.repo.save(entity));
    }

    public SaleContractCategoryVO queryByKey(Long key) {
        SaleContractCategoryDO entity = this.repo.findById(key).orElseGet(SaleContractCategoryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        return SaleContractCategoryConvert.INSTANCE.toVo(entity);
    }

    public List<SaleContractCategoryVO> queryList(SaleContractCategoryQuery query) {
        return SaleContractCategoryConvert.INSTANCE.toVoList(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public PagingVO<SaleContractCategoryVO> paging(SaleContractCategoryQuery query) {
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(SaleContractCategoryConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    SaleContractCategoryDO entity = (SaleContractCategoryDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.repo.save(entity);
                }
            });
        }
    }

    public SaleContractCategoryServiceImpl(SaleContractCategoryRepo repo) {
        this.repo = repo;
    }
}

