/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.tenant.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.tenant.payload.AuthTenantPayload;
import com.elitesland.tw.tw5.api.tenant.query.AuthTenantQuery;
import com.elitesland.tw.tw5.api.tenant.service.AuthTenantService;
import com.elitesland.tw.tw5.api.tenant.vo.AuthTenantVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.tenant.convert.AuthTenantConvert;
import com.elitesland.tw.tw5.server.tenant.dao.AuthTenantDAO;
import com.elitesland.tw.tw5.server.tenant.entity.AuthTenantDO;
import com.elitesland.tw.tw5.server.tenant.repo.AuthTenantRepo;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AuthTenantServiceImpl
extends BaseServiceImpl
implements AuthTenantService {
    private static final Logger log = LoggerFactory.getLogger(AuthTenantServiceImpl.class);
    private final AuthTenantRepo authTenantRepo;
    private final AuthTenantDAO authTenantDAO;

    public PagingVO<AuthTenantVO> paging(AuthTenantQuery query) {
        Page page = this.authTenantRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(AuthTenantConvert.INSTANCE::toVo));
    }

    public PagingVO<AuthTenantVO> queryPaging(AuthTenantQuery query) {
        return this.authTenantDAO.queryPaging(query);
    }

    public List<AuthTenantVO> queryList(AuthTenantQuery query) {
        return AuthTenantConvert.INSTANCE.toVoList(this.authTenantRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<AuthTenantVO> queryListDynamic(AuthTenantQuery query) {
        return this.authTenantDAO.queryListDynamic(query);
    }

    public AuthTenantVO queryByKey(Long key) {
        AuthTenantDO entity = this.authTenantRepo.findById(key).orElseGet(AuthTenantDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AuthTenantVO vo = AuthTenantConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AuthTenantVO insert(AuthTenantPayload payload) {
        AuthTenantDO entityDo = AuthTenantConvert.INSTANCE.toDo(payload);
        return AuthTenantConvert.INSTANCE.toVo((AuthTenantDO)this.authTenantRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public AuthTenantVO update(AuthTenantPayload payload) {
        AuthTenantDO entity = this.authTenantRepo.findById(payload.getId()).orElseGet(AuthTenantDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AuthTenantDO entityDo = AuthTenantConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AuthTenantConvert.INSTANCE.toVo((AuthTenantDO)this.authTenantRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.authTenantRepo.findById(id);
                if (!optional.isEmpty()) {
                    AuthTenantDO entity = (AuthTenantDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.authTenantRepo.save(entity);
                }
            });
        }
    }

    public AuthTenantServiceImpl(AuthTenantRepo authTenantRepo, AuthTenantDAO authTenantDAO) {
        this.authTenantRepo = authTenantRepo;
        this.authTenantDAO = authTenantDAO;
    }
}

