package com.elitesland.tw.tw5.server.common.constants;

import lombok.Getter;

public enum BusinessTeamRoleEnum {
    BASE("BASE","普通成员",100),
    SALE_MANAGER("SALE_MANAGER","销售负责人",2),
    SERVICE_MANAGER("SERVICE_MANAGER","服务负责人",3),
    PURCHASE_MANAGER("PURCHASE_MANAGER","采购负责人",4),
    CHANNEL_MANAGER("CHANNEL_MANAGER","渠道负责人",5),
    PRESALE_MANAGER("PRESALE_MANAGER", "售前负责人",7),
    PAY_MANAGER("PAY_MANAGER", "交付负责人",8),
    SALESMAN("SALESMAN", "业务员",9),
    COMPETITOR_MANAGER("COMPETITOR_MANAGER", "负责人", 10);
    @Getter
    private final String code;
    @Getter
    private final String desc;
    @Getter
    private final Integer sortNo;

    BusinessTeamRoleEnum(String code, String desc,Integer sortNo) {
        this.code = code;
        this.desc = desc;
        this.sortNo = sortNo;
    }

    public static String queryDescByCode(String code){
        BusinessTeamRoleEnum[] values = BusinessTeamRoleEnum.values();
        for(BusinessTeamRoleEnum temp:values){
            if(temp.getCode().equals(code)){
                return temp.getDesc();
            }
        }
        return null;
    }
}
