package com.elitesland.tw.tw5.server.prd.ab.controller;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbInvoicePayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbInvoiceService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbInvoiceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 开票信息管理
 *
 * @author carl.wang
 */
@Api("开票信息管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/ab")
@Slf4j
public class PrdAbInvoiceController {

    private final PrdAbInvoiceService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/invoice/insert")
    public TwOutputUtil insert(PrdAbInvoicePayload payload) {
        PrdAbInvoiceVO vo = service.save(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/invoice/update")
    public TwOutputUtil update(PrdAbInvoicePayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 删除
     *
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param keys       主键id
     * @return result
     */
    @DeleteMapping("/invoice/delete")
    public TwOutputUtil delete(Long bookId, String objectType, Long[] keys) {
        service.delete(bookId, objectType, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param bookId 地址薄主键
     * @return result
     */
    @GetMapping("/invoice/queryList")
    public TwOutputUtil<PrdAbInvoiceVO> queryList(Long bookId) {
        return TwOutputUtil.ok(service.queryList(bookId));
    }

    /**
     * 根据客户主键查询发票信息列表
     *
     * @param customerId 客户主键
     * @return result
     */
//    @GetMapping("/invoice/listByCustomerId")
//    public TwOutputUtil<PrdAbInvoiceVO> listByCustomerId(Long customerId) {
//        return TwOutputUtil.ok(service.listByCustomerId(customerId));
//    }


}
