package com.elitesland.tw.tw5.server.prd.ab.dao;


import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAddressVO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbAddressDO;
//import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbAddressRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class PrdAbAddressDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbAddressRepo repo;
    private final QPrdAbAddressDO qdo = QPrdAbAddressDO.prdAbAddressDO;
//    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.addressIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.addressIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

//    /**
//     * @param bookId
//     * @return
//     * @Description
//     **/
//    public Long queryIdByBookId(Long bookId) {
//        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoCustomer.id).from(qdoCustomer);
//        jpaQuery.where(qdoCustomer.bookId.eq(bookId));
//        jpaQuery.where(qdoCustomer.deleteFlag.eq(0));
//        return jpaQuery.fetchFirst();
//    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdAbAddressDO save(PrdAbAddressDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdAbAddressVO> getJpaQuerySelect() {
        JPAQuery<PrdAbAddressVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdAbAddressVO.class,
                qdo.id,
                qdo.bookId,
                qdo.addressType,
                qdo.country,
                qdo.province,
                qdo.provinceName,
                qdo.city,
                qdo.cityName,
                qdo.district,
                qdo.districtName,
                qdo.detailAddress,
                qdo.remark,
                qdo.addressEmail,
                qdo.defaultAddress
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * @param bookId 地址簿主键
     * @return
     * @Description 主键查询
     **/
    public List<PrdAbAddressVO> queryList(Long bookId) {
        JPAQuery<PrdAbAddressVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 查询列表
     *
     * @param bookId      地址簿id
     * @param addressType 地址类型
     * @return {@link List}<{@link PrdAbAddressVO}>
     */
    public List<PrdAbAddressVO> queryList(Long bookId, String addressType) {
        JPAQuery<PrdAbAddressVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.addressType.eq(addressType));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }
}
