package com.elitesland.tw.tw5.server.prd.office.service.configurers.implementations;

import com.elitesland.tw.tw5.server.prd.office.models.enums.Action;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.FileModel;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.Permission;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.FileConfigurer;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.wrappers.DefaultDocumentWrapper;
import com.elitesland.tw.tw5.server.prd.office.models.enums.DocumentType;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.wrappers.DefaultFileWrapper;
import com.elitesland.tw.tw5.server.prd.office.util.file.FileUtility;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/**
 * 默认配置文件
 *
 * @author duwh
 * @date 2022/06/22
 */
@Service
@Primary
public class DefaultFileConfigurer implements FileConfigurer<DefaultFileWrapper> {

    @Autowired
    private ObjectFactory<FileModel> fileModelObjectFactory;

    @Autowired
    private FileUtility fileUtility;

    //@Autowired
    //private JwtManager jwtManager;

    //@Autowired
    //private Mapper<com.onlyoffice.integration.entities.Permission, Permission> mapper;

    @Autowired
    private DefaultDocumentConfigurer defaultDocumentConfigurer;

    //@Autowired
    //private DefaultEditorConfigConfigurer defaultEditorConfigConfigurer;

    @Override
    public void configure(FileModel fileModel, DefaultFileWrapper wrapper) {  // define the file configurer
        if (fileModel != null) {  // check if the file model is specified
            String fileName = wrapper.getFileName();  // get the fileName parameter from the file wrapper
            Action action = wrapper.getAction();  // get the action parameter from the file wrapper

            DocumentType documentType = fileUtility.getDocumentType(fileName);  // get the document type of the specified file
            fileModel.setDocumentType(documentType);  // set the document type to the file model
            fileModel.setType(wrapper.getType());  // set the platform type to the file model

            //Permission userPermissions = mapper.toModel(wrapper.getUser().getPermissions());  // convert the permission entity to the model
            Permission userPermissions = new Permission();
            //final com.elitesland.tw.tw5crm.server.prd.office.entities.Permission permissions = wrapper.getUser().getPermissions();
            //BeanUtils.copyProperties(permissions,userPermissions);

            String fileExt = fileUtility.getFileExtension(wrapper.getFileName());
            Boolean canEdit = fileUtility.getEditedExts().contains(fileExt);
            if ((!canEdit && action.equals(Action.edit) || action.equals(Action.fillForms)) && fileUtility.getFillExts().contains(fileExt)) {
                canEdit = true;
                wrapper.setAction(Action.fillForms);
            }
            wrapper.setCanEdit(canEdit);

            // define the document wrapper
            DefaultDocumentWrapper documentWrapper = DefaultDocumentWrapper
                .builder()
                .fileName(fileName)
                .permission(updatePermissions(userPermissions, action, canEdit))
                .favorite(wrapper.getUser().getFavorite())
                .build();

            defaultDocumentConfigurer.configure(fileModel.getDocument(), documentWrapper);  // define the document configurer
            //defaultEditorConfigConfigurer.configure(fileModel.getEditorConfig(), wrapper);  // define the editorConfig configurer

            //Map<String, Object> map = new HashMap<>();
            //map.put("type", fileModel.getType());
            //map.put("documentType", documentType);
            //map.put("document", fileModel.getDocument());
            //map.put("editorConfig", fileModel.getEditorConfig());

            //fileModel.setToken(jwtManager.createToken(map));  // create a token and set it to the file model
        }
    }

    /**
     * 获得文件模型
     *
     * @param wrapper 包装器
     * @return {@link FileModel}
     */
    @Override
    public FileModel getFileModel(DefaultFileWrapper wrapper) {
        FileModel fileModel = fileModelObjectFactory.getObject();
        // and configure it
        configure(fileModel, wrapper);
        return fileModel;
    }

    private Permission updatePermissions(Permission userPermissions, Action action, Boolean canEdit) {
        userPermissions.setComment(
            !action.equals(Action.view)
                && !action.equals(Action.fillForms)
                && !action.equals(Action.embedded)
                && !action.equals(Action.blockcontent)
        );

        userPermissions.setFillForms(
            !action.equals(Action.view)
                && !action.equals(Action.comment)
                && !action.equals(Action.embedded)
                && !action.equals(Action.blockcontent)
        );

        userPermissions.setReview(canEdit &&
            (action.equals(Action.review) || action.equals(Action.edit)));

        userPermissions.setEdit(canEdit &&
            (action.equals(Action.view)
                || action.equals(Action.edit)
                || action.equals(Action.filter)
                || action.equals(Action.blockcontent)));

        return userPermissions;
    }
}
