package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_org_dimension")
@org.hibernate.annotations.Table(appliesTo = "prd_org_dimension", comment = "组织维度表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgDimensionDO extends BaseModel implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @Comment("历史版本id")
    @Column()
    private Long versionId = 0L;

    @Comment("维度名称")
    @Column()
    private String dimensionName;

    @Comment("维度编号")
    @Column()
    private String dimensionCode;

    @Comment("维度状态")
    @Column()
    private Integer dimensionStatus = 0;

    @Comment("是否默认维度")
    @Column()
    private Integer defaultFlag = 0;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;
    private String extString7;
    private String extString8;
    private String extString9;
    private String extString10;

    @Override
    public Object clone() {
        PrdOrgDimensionDO stu = null;
        try {
            stu = (PrdOrgDimensionDO) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return stu;
    }
}
