package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackProcessQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackProcessVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackProcessDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemProblemFeedbackProcessDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemProblemFeedbackProcessRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdSystemProblemFeedbackProcessDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemProblemFeedbackProcessRepo repo;
    private final QPrdSystemProblemFeedbackProcessDO qdo = QPrdSystemProblemFeedbackProcessDO.prdSystemProblemFeedbackProcessDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemProblemFeedbackProcessDO save(PrdSystemProblemFeedbackProcessDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存数组
     *
     * @param adoList do对象数组
     * @return
     */
    public List<PrdSystemProblemFeedbackProcessDO> saveAll(List<PrdSystemProblemFeedbackProcessDO> adoList) {
        return repo.saveAll(adoList);

    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemProblemFeedbackProcessVO> queryListDynamic(PrdSystemProblemFeedbackProcessQuery query) {
        JPAQuery<PrdSystemProblemFeedbackProcessVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemProblemFeedbackProcessVO> getJpaQueryWhere(PrdSystemProblemFeedbackProcessQuery query) {
        JPAQuery<PrdSystemProblemFeedbackProcessVO> jpaQuery = getJpaQuerySelect();

        if (!CollectionUtils.isEmpty(query.getFeedbackIdList())) {
            jpaQuery.where(qdo.feedbackId.in(query.getFeedbackIdList()));
        }
        if (StringUtils.hasText(query.getProcessType())) {
            jpaQuery.where(qdo.processType.eq(query.getProcessType()));
        }
        jpaQuery.where(qdo.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemProblemFeedbackProcessVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemProblemFeedbackProcessVO.class,
                qdo.feedbackId,
                qdo.content,
                qdo.fileCodes,
                qdo.processType,
                qdo.fileCodes,
                qdo.id,
                qdo.createTime,
                qdo.createUserId,
                qdo.creator
        )).from(qdo);
    }
}
